<?php
class SppPullMessageController extends AppController {

	var $name = 'SppPullMessage';
	var $uses = array('SppPullMessage','SppOrganization','SppRankMaster');
	var $helpers = array('Html', 'Form', 'Session', 'Dialog');
	var $components = array('Auth', 'Session');

	function beforeFilter() {
		parent::beforeFilter();
		$this->Auth->allow('index', 'submitMessage', 'check','addMessageForLearner');
		// Load config file
		Configure::load('settings');
 		if($this->action != "addMessageForLearner"){
			// check session and role
			if(!$this->isSupporter()){
				$this->render('/elements/error');
				return;
			}
 		}
	}


	function index() {
		$currentUser = $this->Auth->user();
		$roles = $this->getUserRole($currentUser['SppUser']['id']);

		$this->set('roles', $roles);

		if(isset($this->params['url']['delid'])){
			$delid = $this->params['url']['delid'];
			if($delid != ""){
				$this->SppPullMessage->delete($delid);
				$content_url = $this->Session->read('content.url');
				$this->redirect('/' . $content_url.'/spppullmessage/index');
			}
			$this->set("delid",$delid);
		}
		$organizations = null;
		if($this->isSystemManagement()){
			$organizations = $this->SppOrganization->find('all',array('fields'=>'CONCAT(code_large,code_middle,code_small) AS code, organization_name'));
			$this->set('is_sys_admin', true);
		}else{
			$organizations = $this->SppOrganization->getOrgCodeForAchivementUser($currentUser['SppUser']['id']);
			$this->set('is_sys_admin', false);
		}
		
		$ranks = $this->SppRankMaster->find('all', array('conditions' => array('mark <>' => NULL)));
		$this->set('organizations',$organizations);
		$this->set('ranks',$ranks);

		$messages = null;
		if($this->isSystemManagement()){
			$messages = $this->SppPullMessage->find('all', array('order'=>'SppPullMessage.created_datetime DESC', 'limit'=>10));
		}else{
			$messages = $this->SppPullMessage->find('all', array('order'=>'SppPullMessage.created_datetime DESC', 'limit'=>10,'conditions' => array('sender_id' => $currentUser['SppUser']['id'])));
		}
		$this->set("messages", $messages);
		
		
		if($this->Session->read('PUSH.FILEERROR')!=null){
			$this->set("pushError", $this->Session->read('PUSH.FILEERROR'));
			$this->Session->delete('PUSH.FILEERROR');
		}
		$this->set('fullurl', FULL_BASE_URL . $this->webroot);
	}

	function submitMessage() {

		$currentUser = $this->Auth->user();
		if(!empty($this->data)) {
			$this->SppPullMessage->create();
			
			$this->data['SppPullMessage']['created_datetime'] = date('Y-m-d H:i:s');
			if($this->data['SppPullMessage']['delivery_date']=='' || $this->data['SppPullMessage']['delivery_date'] == '0000-00-00'){
				$this->data['SppPullMessage']['delivery_date'] = NULL;
			} else {
				$this->data['SppPullMessage']['delivery_date'] = str_replace('/', '-', $this->data['SppPullMessage']['delivery_date']);
			}

			if($this->data['delivery_type'] == 0){
				$this->data['SppPullMessage']['all'] = 1;
			} else {
				$this->data['SppPullMessage']['all'] = 0;
				if(isset($this->data['rank']) && $this->data['rank'] != -1){
					$this->data['SppPullMessage']['rank_id'] = $this->data['rank'];
				}
				if(isset($this->data['organization_code']) && $this->data['organization_code'] != -1){
					$this->data['SppPullMessage']['organization_code'] = $this->data['organization_code'];
				}
			}
			

			$this->SppPullMessage->begin();
			try{
				$this->data['SppPullMessage']['message'] = nl2br($this->data['SppPullMessage']['message']); 
				$this->data['SppPullMessage']['sender_id'] = $currentUser['SppUser']['id'];
				if ($this->SppPullMessage->save($this->data)) {
					$this->SppPullMessage->commit();
					$this->redirect(array('action'=>'index'));
				}
			} catch (Exception $e) {
				$this->SppPullMessage->rollback();
			}
		}
	}

	function addMessageForLearner(){
		$this->autoRender = false;
		$learner_id = $_POST['learner_id'];
		$message_content = $_POST['message_content'];
		$delivery_date = $_POST['delivery_date'];
		if($delivery_date=='' || $delivery_date == '0000-00-00'){
			$delivery_date = NULL;
		} else {
			$delivery_date = str_replace('/', '-', $delivery_date);
		}
		$this->SppPullMessage->begin();
		try{
			$this->SppPullMessage->create();
			$this->SppPullMessage->set(array(
			'message' => nl2br($message_content),
			'delivery_date' => $delivery_date,
			'learner_id' => $learner_id,
			'created_datetime' =>date('Y-m-d H:i:s'),
			'all' => false));
			if ($this->SppPullMessage->save()) {
				$this->SppPullMessage->commit();
				return true;
			}
		} catch (Exception $e) {
			$this->SppPullMessage->rollback();
		}
		return false;
			
	}

	function check() {
		Configure::write('debug', 1);
		$this->layout = 'ajax';
		$this->autoRender = false;

		//$msg = Configure::read('Message.ERR_PUSH_MESSAGE_LENGTH');
		if(!empty($_POST['msg'])) {
			return strlen($_POST['msg']);
		} else {
			return 0;
		}
	}

	function _pushMessage($message, $deviceToken){
		// Put your device token here (without spaces):
		//$deviceToken = '40e67dd6b87f91f6de4d3b6fe01cd5a7e3c72770bb0d5cbb12842dccb2a3a613';
		//Put your private key's passphrase here:
		//$passphrase = 'tuan123';
		$passphrase = Configure::read('Push.passphrase');
		// Put your alert message here:
		if(!isset($message) || $message ==null)
		{
			//$this->Pass4v->errorResponse(Configure::read('errorNoContentInfo'),"", $xml);
			return false;
		}

		////////////////////////////////////////////////////////////////////////////////

		$ctx = stream_context_create();
		$certificate =  Configure::read('Push.certpath');
		stream_context_set_option($ctx, 'ssl', 'local_cert', $certificate);
		stream_context_set_option($ctx, 'ssl', 'passphrase', $passphrase);

		// Open a connection to the APNS server
		$fp = stream_socket_client(
		Configure::read('Push.apns'), $err,
		$errstr, 60, STREAM_CLIENT_CONNECT|STREAM_CLIENT_PERSISTENT, $ctx);

		if (!$fp){
			$this->Session->write('PUSH.FILEERROR', 'PEMファイルが存在しません、またはPEMファイルがエラーになります。');
			return;
		}
		// Create the payload body
		$body['aps'] = array(
			'alert' => $message,
			'sound' => 'default'
			);

			// Encode the payload as JSON
			$payload = json_encode($body);

			// Build the binary notification
			$msg = chr(0) . pack('n', 32) . pack('H*', $deviceToken) . pack('n', strlen($payload)) . $payload;

			// Send it to the server
			if (!$result = fwrite($fp, $msg, strlen($msg)))
			return false;
			else
			return true;

			// Close the connection to the server
			fclose($fp);
			return false;
	}

	/**
	 * Author: TuanNM
	 * Date: 2013/03/05
	 * Push message to Android device
	 * @param $message
	 * @param $deviceToken
	 */
	function _androidPush($message, $deviceToken){
		//request url
		$url = Configure::read('Push.android');
			
		//your api key
		$apiKey = Configure::read('Push.androidapikey');
			
		//registration ids
		$registrationIDs = array($deviceToken);
			
		//payload data
		$data   = array('message' => $message);
			
		$fields = array('registration_ids' => $registrationIDs,
		                'data' => $data);
			
		//http header
		$headers = array('Authorization: key=' . $apiKey,
		                 'Content-Type: application/json');
			
		//curl connection
		$ch = curl_init();
			
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true );
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
			
		$result = curl_exec($ch);
			
		curl_close($ch);

		$result = json_decode($result, true);
		if($result['success'] == 1){
			return true;
		} else {
			return false;
		}
	}

}
?>