<?php
class SppContentFile extends AppModel {
	var $name 		= 'SppContentFile';
	var $validate = array(
		'content_id' => array(
			'numeric' => array(
				'rule' => array('numeric', 'notempty'),
			),
		),
		'users_id' => array(
			'numeric' => array(
				'rule' => array('numeric', 'notempty'),
				
			),
		),
		'filename' => array(
			'notempty' => array(
				'rule' => array('notempty'),
				
			),
		),
		'path' => array(
			'notempty' => array(
				'rule' => array('notempty'),
			),
		)
		
	);
	var $belongsTo = array(
		'SppContent' => array(
			'className' => 'SppContent',
			'foreignKey' => 'content_id',
			'fields' => '',
			'order' => ''
		),
		'SppUser' => array(
			'className' => 'SppUser',
			'foreignKey' => 'user_id',
			'fields' => '',
			'order' => ''
		),
	);
    
	/**
	 * #27665
	 * checkContentFileIsActive
	 * @dateTime 20140114
	 * @author haitlt
	 */
    function checkContentFileIsActive($contentFileId){
    	$conditions = array('SppContentFile.id'=> $contentFileId);
		$contentFile = $this->find('first',array('conditions'=>$conditions));
    	if($contentFile['SppContentFile']['active_flag'] == '1')
    		return true;
    	return false;
    }
}
?>