<?php
//BBS 2012.11
class SppStudyRecord extends AppModel {
	var $name = "SppStudyRecord";
	var $actsAs = array('Transactional');

	/**
	 *
	 * get list study record
	 * @param string $learner_id
	 * @param string $first_name
	 * @param string $last_name
	 * @param string $organization_code
	 * @param int $user_id: id of user login
	 * @param boolean $is_only_achivement_role: is true if user login is only have achivement management role
	 */
	public function getDataStudyRecord($learner_id, $first_name, $last_name, $organization_code,
	$user_id = NULL, $is_only_achivement_role = false, $quiz_progress = ""){

		$conditions = array();
		$fields = "";
		$joins = array();
		$joins[]= array(
            'table' => 'spp_learners',
            'alias' => 'SppLearner',
            'type' => 'inner',
            'conditions' => array('SppLearner.id = SppStudyRecord.learner_id')
		);
		$joins[]= array(
            'table' => 'spp_rank_masters',
            'alias' => 'SppRankMaster',
            'type' => 'inner',
            'conditions' => array('SppRankMaster.id = SppStudyRecord.rank_id')
		);

		if(!empty($learner_id)){
			$conditions[] = "SppStudyRecord.learner_id LIKE '%".$learner_id."%'";
		}
		if(!empty($first_name)){
			$conditions['OR']= array("SppLearner.first_name LIKE '%".$first_name."%'", "SppLearner.first_name_kana LIKE '%".$first_name."%'" );
		}
		if(!empty($last_name)){
			$conditions['OR']= array("SppLearner.last_name LIKE '%".$last_name."%'", "SppLearner.last_name_kana LIKE '%".$last_name."%'" );
		}
		if(!empty($organization_code)){
			$conditions['SppLearner.organization_code'] = $organization_code;
		} else {
			if($is_only_achivement_role == true && !empty($user_id)){

				$joins[]= array(
	            'table' => 'spp_organizations',
	            'alias' => 'SppOrganization',
	            'type' => 'inner',
	            'conditions' => array('CONCAT(code_large,code_middle,code_small) = SppLearner.organization_code')
				);

				$joins[]= array(
	            'table' => 'spp_user_organizations',
	            'alias' => 'SppUserOrganization',
	            'type' => 'inner',
	            'conditions' => array('SppUserOrganization.organization_id = SppOrganization.id')
				);

				$conditions['SppUserOrganization.user_id'] = $user_id;
			}
		}
		
		if ($quiz_progress == "0" || !empty($quiz_progress)) {
			$conditions[] = 'SppStudyRecord.quiz_progress <= '.$quiz_progress;
		}

		$fields = "SppStudyRecord.*, SppLearner.organization_code, SppLearner.first_name,
		 SppLearner.last_name, SppLearner.email, SppLearner.created_datetime, SppRankMaster.name";
		return array(
					'fields' => $fields,
				    'limit' => Configure::read('STUDY_RECORD.NUMBER_OF_PAGE'),
					'conditions' => $conditions,
					'joins' => $joins);

	}

	public function getDataStudyRecord2($learner_id, $first_name, $last_name, $organization_code,
	$user_id = NULL, $is_only_achivement_role = false, $quiz_progress = ""){

		$conditions = array();
		$fields = "";
		$joins = array();
		$joins[]= array(
            'table' => 'spp_learners',
            'alias' => 'SppLearner',
            'type' => 'inner',
            'conditions' => array('SppLearner.id = SppStudyRecord.learner_id')
		);
		$joins[]= array(
            'table' => 'spp_rank_masters',
            'alias' => 'SppRankMaster',
            'type' => 'inner',
            'conditions' => array('SppRankMaster.id = SppStudyRecord.rank_id')
		);

		if(!empty($learner_id)){
			$conditions[] = "SppLearner.email LIKE '%".$learner_id."%'";
		}
		if(!empty($first_name)){
			$conditions['OR']= array("SppLearner.first_name LIKE '%".$first_name."%'", "SppLearner.first_name_kana LIKE '%".$first_name."%'" );
		}
		if(!empty($last_name)){
			$conditions['OR']= array("SppLearner.last_name LIKE '%".$last_name."%'", "SppLearner.last_name_kana LIKE '%".$last_name."%'" );
		}
		if(!empty($organization_code)){
			$conditions['SppLearner.organization_code'] = $organization_code;
		} else {
			if($is_only_achivement_role == true && !empty($user_id)){

				$joins[]= array(
	            'table' => 'spp_organizations',
	            'alias' => 'SppOrganization',
	            'type' => 'inner',
	            'conditions' => array('CONCAT(code_large,code_middle,code_small) = SppLearner.organization_code')
				);

				$joins[]= array(
	            'table' => 'spp_user_organizations',
	            'alias' => 'SppUserOrganization',
	            'type' => 'inner',
	            'conditions' => array('SppUserOrganization.organization_id = SppOrganization.id')
				);

				$conditions['SppUserOrganization.user_id'] = $user_id;
			}
		}
		
		if ($quiz_progress == "0" || !empty($quiz_progress)) {
			$conditions[] = 'SppStudyRecord.quiz_progress <= '.$quiz_progress;
		}

		$fields = "SppStudyRecord.*, SppLearner.organization_code, SppLearner.first_name,
		 SppLearner.last_name, SppLearner.email,SppLearner.created_datetime, SppRankMaster.name";
		return array(
					'fields' => $fields,
				    'limit' => Configure::read('STUDY_RECORD.NUMBER_OF_PAGE'),
					'conditions' => $conditions,
					'joins' => $joins,
					'order' => 'SppLearner.email');

	}

	function getAllForCSV($user_id,$is_only_achivement_role){
		$conditions = array();
		$fields = "";
		$joins = array();
		$joins[]= array(
            'table' => 'spp_learners',
            'alias' => 'SppLearner',
            'type' => 'inner',
            'conditions' => array('SppLearner.id = SppStudyRecord.learner_id')
		);
		$joins[]= array(
            'table' => 'spp_rank_masters',
            'alias' => 'SppRankMaster',
            'type' => 'inner',
            'conditions' => array('SppRankMaster.id = SppStudyRecord.rank_id')
		);

		if($is_only_achivement_role == true && !empty($user_id)){

			$joins[]= array(
	            'table' => 'spp_organizations',
	            'alias' => 'SppOrganization',
	            'type' => 'inner',
	            'conditions' => array('CONCAT(code_large,code_middle,code_small) = SppLearner.organization_code')
			);

			$joins[]= array(
	            'table' => 'spp_user_organizations',
	            'alias' => 'SppUserOrganization',
	            'type' => 'inner',
	            'conditions' => array('SppUserOrganization.organization_id = SppOrganization.id')
			);

			$conditions['SppUserOrganization.user_id'] = $user_id;
		}

		$fields = "SppStudyRecord.*, SppLearner.organization_code, SppLearner.first_name,
		 SppLearner.last_name,SppLearner.email, SppRankMaster.name";
		return $this->find('all',array(
					'fields' => $fields,
					'conditions' => $conditions,
					'joins' => $joins, 'order'=>'SppLearner.email'));
	}

	function getStudyRecordByLearner($learner_id){
		return $this->find('first',array('conditions' => array('learner_id' => $learner_id)));
	}


	/**
	 * Get the detail stduy record by learner_id.
	 * @param unknown_type learner_id
	 */
	public function getDetail($learner_id = null)
	{
		if(!$learner_id) {
			return;
		}

		// Build sql
		$sql = <<<SQL
		SELECT DISTINCT LOGS.category_no AS category_no 
						,COALESCE(LOGS.category_name) AS category_name 
						,SUM( LOGS.last_answer )
						,COUNT( LOGS.quiz_no )
						,QUIZZ.quiz_count
						,SUM( LOGS.incorrect_count )
						,COALESCE(round((COUNT( LOGS.quiz_no ) / QUIZZ.quiz_count)*100
											,0), 0)							AS progress_rate	-- 学習進捗率（NULLの場合は0）
					
						,COALESCE(round((SUM( LOGS.last_answer )/ COUNT( LOGS.quiz_no )*100)
											,0), 0)							AS achievement_rate	-- 正解率（NULLの場合は0）
						
		FROM spp_quiz_logs AS LOGS
		LEFT JOIN (
				SELECT	 COUNT(*) AS quiz_count,
						category_no
				FROM	 quizzs
				GROUP BY category_no
		)	QUIZZ
		ON 	QUIZZ.category_no = LOGS.category_no
		WHERE LOGS.learner_id =  '{$learner_id}'
		GROUP BY LOGS.category_no
		ORDER BY LOGS.category_no ASC
SQL;

		//Execute query...
		return $this->query($sql);
	}

	/**
	 *
	 * get extend days which gain from learner's rank
	 * @param unknown_type $learner_id
	 */
	function getExtendDays($learner_id){
		$joins = array();
		$joins[] = array(
            'table' => 'spp_rank_masters',
            'alias' => 'SppRankMaster',
            'type' => 'left',
            'conditions' => array('SppRankMaster.id = SppStudyRecord.rank_id')
		);
		$fields = "SppRankMaster.extend_days";
		$study_record = $this->find('first',array(
					'fields' => $fields,
					'conditions' => array('SppStudyRecord.learner_id' => $learner_id),
					'joins' => $joins));
		if($study_record && !empty($study_record['SppRankMaster']['extend_days'])){
			return $study_record['SppRankMaster']['extend_days'];
		}
		return 0;
	}

	function insertStudyRecord($learner_id, $start_date, $learning_days, $learning_time_total, $learning_progress,
	$all_quiz_count, $all_try_count,$all_miss_count, $all_achievement_count, $rank_id, $total_mark, $start_app_count){
		$this->set(array(
					'learner_id' => $learner_id,
					'start_date' => $start_date,
					'learning_days' => $learning_days,
					'learning_time_seconds' => $learning_time_total,
					'learning_hours' => ceil($learning_time_total/3600),
					'learning_average_minutes' => $learning_days == 0 ? 0:ceil(ceil($learning_time_total/60)/$learning_days),
					'learning_progress' => $learning_progress,
					'quiz_progress' => $all_quiz_count == 0 ? 0:round(($all_try_count/$all_quiz_count)*100,0),
					'correct_rate' => $all_try_count == 0 ? 0:round(($all_achievement_count/$all_try_count)*100,0),
					'rank_id' =>$rank_id,
					'mark' =>$total_mark,
					'all_quiz_count' => $all_quiz_count,
					'all_try_count' => $all_try_count,
					'all_miss_count' => $all_miss_count,
					'all_achievement_count' => $all_achievement_count,
					'start_app_count' => $start_app_count
		));
		if($this->save()){
			return true;
		}
		return false;
	}

	function updateStudyRecord($study_record, $learning_days, $learning_time_total, $learning_progress, $all_quiz_count,
							   $all_try_count, $all_miss_count, $all_achievement_count, $rank_id, $total_mark, $start_app_count){
		$study_record['SppStudyRecord']['learning_days'] = $learning_days;
		$study_record['SppStudyRecord']['learning_time_seconds'] = $learning_time_total;
		$study_record['SppStudyRecord']['learning_hours'] = ceil($learning_time_total/3600);
		$study_record['SppStudyRecord']['learning_average_minutes'] = $learning_days == 0 ? 0: ceil(ceil($learning_time_total/60)/$learning_days);
		$study_record['SppStudyRecord']['learning_progress'] = $learning_progress;
		$study_record['SppStudyRecord']['quiz_progress'] =	$all_quiz_count == 0 ? 0:round(($all_try_count/$all_quiz_count)*100,0);
		$study_record['SppStudyRecord']['correct_rate'] = $all_try_count == 0 ? 0:round(($all_achievement_count/$all_try_count)*100,0);
		$study_record['SppStudyRecord']['rank_id'] = $rank_id;
		$study_record['SppStudyRecord']['mark'] = $total_mark;
		$study_record['SppStudyRecord']['all_quiz_count'] = $all_quiz_count;
		$study_record['SppStudyRecord']['all_try_count'] = $all_try_count;
		$study_record['SppStudyRecord']['all_miss_count'] = $all_miss_count;
		$study_record['SppStudyRecord']['all_achievement_count'] = $all_achievement_count;
		$study_record['SppStudyRecord']['start_app_count'] = $start_app_count;
		if($this->save($study_record)){
			return true;
		}
		return false;
	}
	
	/**
	 * 
	 * get current position and mark of prev position (using on my page)
	 * @param unknown_type $learner_id
	 * @param unknown_type $total_mark
	 * @param unknown_type $learning_time_total
	 * @param unknown_type $rank_id
	 */
	function getCurrentPosition($learner_id, $total_mark, $learning_time_total, $rank_id){
		$query = "SELECT COUNT(*) as position, MIN( mark + point_update ) as prev_mark
					  FROM spp_study_records 
					  WHERE ((mark + point_update) > ".$total_mark." 
					  		  OR ((mark + point_update) = ".$total_mark." AND learning_time_seconds > ".$learning_time_total.") 
					          OR ((mark + point_update) = ".$total_mark." AND learning_time_seconds = ".$learning_time_total." AND learner_id < '".$learner_id."')) 
					        AND invalid_flg = 0 AND rank_id = ".$rank_id;
		$result_sql = mysql_query($query) or die(mysql_error());
			
		return mysql_fetch_array($result_sql);
	}
	
	/**
	 * 
	 * get mark of next position (using on my page)
	 * @param unknown_type $learner_id
	 * @param unknown_type $total_mark
	 * @param unknown_type $learning_time_total
	 * @param unknown_type $rank_id
	 */
	function getNextMark($learner_id, $total_mark, $learning_time_total, $rank_id){
		$query = "SELECT MAX( mark + point_update ) as next_mark 
					  FROM spp_study_records 
					  WHERE ((mark + point_update) < ".$total_mark." 
					  		  OR ((mark + point_update) = ".$total_mark." AND learning_time_seconds < ".$learning_time_total.") 
					          OR ((mark + point_update) = ".$total_mark." AND learning_time_seconds = ".$learning_time_total." AND learner_id > '".$learner_id."')) 
					        AND invalid_flg = 0 AND rank_id = ".$rank_id;
		$result_sql = mysql_query($query) or die(mysql_error());
		return mysql_fetch_array($result_sql);
	}
	
	public function getLearnerGeneralSummary($learner_id = null)
	{
		if(!$learner_id) {
			return;
		}
		// Build sql
		$sql = <<<SQL
		SELECT DISTINCT COALESCE(round((LOGS.learner_progress / QUIZZ.quiz_count)*100,0), 0)	AS learner_progress_rate
				,COALESCE(round((SUM( LOGS.last_answer )/ LOGS.learner_progress*100),0), 0)	AS learner_achievement_rate	
				,LEARNING_LOG.sum_learning_time * 1 AS learner_sum_learning_time
				FROM (SELECT spp_quiz_logs.learner_id, spp_quiz_logs.last_answer, SUBLOGS1.learner_progress FROM spp_quiz_logs, 
							(SELECT DISTINCT 
								COALESCE(COUNT(*))	
								AS learner_progress 
								FROM spp_quiz_logs 
								WHERE spp_quiz_logs.learner_id = '{$learner_id}') 
							AS SUBLOGS1 
						WHERE spp_quiz_logs.learner_id = '{$learner_id}') 
						AS LOGS , 
				(SELECT	COUNT(*) AS quiz_count
						FROM quizzs) 
				AS QUIZZ, 
				( SELECT SUM(TIMESTAMPDIFF(SECOND,spp_learning_logs.time_start,time_end)) 
					AS sum_learning_time FROM spp_learning_logs 
					WHERE spp_learning_logs.learner_id = '{$learner_id}') 
				AS LEARNING_LOG
		WHERE LOGS.learner_id =  '{$learner_id}'
SQL;

		//Execute query...
		return $this->query($sql);
	}
	
	public function getOrgGeneralSummary($orgCode = null)
	{
		if(!$orgCode) {
			return;
		}
		// Build sql
		$sql = <<<SQL
		SELECT round (AVG(round((LOGS.learner_progress / QUIZZ.quiz_count)*100,0)),0)	AS avg_progress_rate
			, round(AVG(round((LOGS.last_answer  / LOGS.learner_progress )*100,0)),0)	AS avg_achievement_rate	
			, round(AVG(LOGS.sum_learning_time),0) AS avg_sum_learning_time
				FROM (SELECT SUBLOGS1.learner_id, COALESCE(SUBLOGS1.last_answer,0) AS last_answer, COALESCE(SUBLOGS1.learner_progress,0) AS learner_progress,COALESCE(LEARNING_LOG.sum_learning_time,0) AS sum_learning_time  FROM 
							(SELECT spp_learners.id AS learner_id,SUM(spp_quiz_logs.last_answer)AS last_answer, 
								COUNT(*)
								AS learner_progress 
								FROM spp_learners LEFT JOIN spp_quiz_logs ON spp_quiz_logs.learner_id = spp_learners.id
								WHERE spp_learners.organization_code = '{$orgCode}' 
								GROUP BY spp_quiz_logs.learner_id) 
							AS SUBLOGS1 
							LEFT JOIN 
							( SELECT spp_learners.id as learner_id, SUM(TIMESTAMPDIFF(SECOND,spp_learning_logs.time_start,spp_learning_logs.time_end)) 
							AS sum_learning_time FROM spp_learners LEFT JOIN spp_learning_logs ON spp_learning_logs.learner_id = spp_learners.id 
							WHERE spp_learners.organization_code = '{$orgCode}') 
							AS LEARNING_LOG
							ON SUBLOGS1.learner_id = LEARNING_LOG.learner_id
					)
					AS LOGS, 

					(SELECT	COUNT(*) AS quiz_count
							FROM quizzs) 
					AS QUIZZ

SQL;

		//Execute query...
		return $this->query($sql);
	}
	public function getOrgGeneralSummaryFix($orgCode = null)
	{
		if(!$orgCode) {
			return;
		}
		// Build sql
		$sql = <<<SQL
		SELECT round (AVG(round((LOGS.learner_progress / QUIZZ.quiz_count)*100,0)),0)	AS avg_progress_rate
			, round(AVG(round((LOGS.last_answer  / LOGS.learner_progress )*100,0)),0)	AS avg_achievement_rate	
			, round(AVG(LOGS.sum_learning_time),0) AS avg_sum_learning_time
				FROM (SELECT SUBLOGS1.learner_id, COALESCE(SUBLOGS1.last_answer,0) AS last_answer, COALESCE(SUBLOGS1.learner_progress,0) AS learner_progress,COALESCE(LEARNING_LOG.sum_learning_time,0) AS sum_learning_time  FROM 
							(SELECT spp_learners.id AS learner_id,SUM(spp_quiz_logs.last_answer)AS last_answer, 
								COUNT(*)
								AS learner_progress 
								FROM spp_learners LEFT JOIN spp_quiz_logs ON spp_quiz_logs.learner_id = spp_learners.id
								WHERE spp_learners.organization_code = '{$orgCode}'  AND last_answer IS NOT NULL
								GROUP BY spp_quiz_logs.learner_id) 
							AS SUBLOGS1 
							LEFT JOIN 
							( SELECT spp_learners.id as learner_id, SUM(TIMESTAMPDIFF(SECOND,spp_learning_logs.time_start,spp_learning_logs.time_end)) 
							AS sum_learning_time FROM spp_learners LEFT JOIN spp_learning_logs ON spp_learning_logs.learner_id = spp_learners.id 
							WHERE spp_learners.organization_code = '{$orgCode}') 
							AS LEARNING_LOG
							ON SUBLOGS1.learner_id = LEARNING_LOG.learner_id
					)
					AS LOGS, 

					(SELECT	COUNT(*) AS quiz_count
							FROM quizzs) 
					AS QUIZZ

SQL;

		//Execute query...
		return $this->query($sql);
	}

}