<?php // $Id$
/**
 * @copyright     2011 (c) SEVENSEAS TECHWORKS Co., Ltd. All Rights Reserved.
 * @package       Dialog helper
 * @since         2011-07-14
 * We use CakePHP(tm) ver 1.3.9
 */

class DialogHelper extends AppHelper {

    var $helpers = array('Form');
    /**
     * Link to dialog confirm
     *
     * @param string $title title of link
     * @param array  $url url redirect after click button ok in confirm dialog
     * @param string $type this is type of link ex: button | link button is default
     * @return string           expire date string "-1", if $nochache set false then return formatted date string
     */
    function confirmLink($title='',$msg='',$urlprocess=null,$type='button', $controller=null, $class=null)
    {
        switch($type){
            case 'link':
                $link = '<a href="'.Dispatcher::baseUrl().'/' . $controller . '/dialogconfirm?urlback='.urlencode($this->here).'&urlprocess='.urlencode($urlprocess).'&msg='.urlencode($msg).'">'.$title.'</a>';
                break;
            case 'button':
                $link =$this->Form->button($title, array('type'=>'button','class'=>$class,'onclick'=>'location.href = \''.Dispatcher::baseUrl().'/' . $controller . '/dialogconfirm?urlback='.urlencode($this->curPageURL()).'&urlprocess='.urlencode($urlprocess).'&msg='.urlencode($msg).'\';'));
                break;
    
        }
        return $link;
    }
    
    //get Current url
    function curPageURL() {
        $pageURL = 'http';
            if (@$_SERVER["HTTPS"] == "on") {$pageURL .= "s";}
                $pageURL .= "://";
            if ($_SERVER["SERVER_PORT"] != "80") {
                $pageURL .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"].$_SERVER["REQUEST_URI"];
            } else {
                $pageURL .= $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];
            }
        return $pageURL;
    }

   

}
?>