import config       from './config.js';
import Category     from './category.js';
import Quiz         from './quiz.js';
import QuizRecorder from './quizRecorder.js'; 
import Login        from './login.js';
import User         from './user.js';
import Mypage       from './mypage.js';
import Continue     from './continue.js'; 
import db           from "./db";
import SyncData     from "./syncData";
import Dexie        from 'dexie';
import Packaged_sync from './packaged_sync.js'; 
import Message from './message.js';
import Random from './random.js';
import Incorrect     from './incorrect.js';
import RelatedImages     from './related_images.js';
import LearningLog     from './learning_logs.js';
import { randomArray, randomObject, createListQuizIncorrectRandom, functHandleSetFaceMark, IsJsonString, customContentQuiz, customContentQuiz2, checkBeforeSubmitAnswer, checkBeforeSubmitAnswer2, getListFillBlank , customContentQuizForAnswer, autoClearCache} from './common';
import { Circlebar, progress_fnc} from './circle';
import indexDB_Cl  from './indexdb';
import client_JS from  './device_info';

const $             = require('jquery');
const jsCookie      = require('js-cookie');
const page          = require('page');
const R             = require('ramda');
var Base64          = require('js-base64').Base64;
const clientjs = require('clientjs');
// import $ from 'jquery';
import  './jquery-ui';

const categoryListTemplate           = require('../template/category/list-cat.hbs');
const subcategoryListTemplate        = require('../template/category/list.hbs');
const categoryContinueTemplate       = require('../template/category/continue.hbs');
const categoryIncorrectTemplate      = require('../template/category/incorrect.hbs');
const categoryNotAnsweredYetTemplate = require('../template/category/not-answered-yet.hbs');
const categoryBookmarkTemplate       = require('../template/category/bookmark.hbs');
const categoryRandomTemplate         = require('../template/category/random.hbs');
const categoryRedSheetTemplate       = require('../template/category/red-sheet.hbs');
const quizQuestionYesNoTemplate      = require('../template/quiz/question-yes-no.hbs');
const quizQuestionChoicesTemplate    = require('../template/quiz/question-choices.hbs');
const quizQuestionFullBlankTemplate    = require('../template/quiz/question-fill-blank.hbs');
const quizQuestionDescriptionTemplate  = require('../template/quiz/question-description.hbs');
const quizAnswerYesNoTemplate        = require('../template/quiz/answer-yes-no.hbs');
const quizAnswerChoicesTemplate      = require('../template/quiz/answer-choices.hbs');
const quizAnswerChoicesTemplate2      = require('../template/quiz/answer-choices2.hbs');
const quizRedSheetTemplate           = require('../template/quiz/red-sheet.hbs');
const loginTemplate                  = require('../template/login/login.hbs');
const userDetailTemplate             = require('../template/user/detail.hbs');
const userMessageTemplate            = require('../template/user/message.hbs');
const userMessageOneTemplate         = require('../template/user/message-select.hbs');
const userConfiguration              = require('../template/user/configuration.hbs');
const userEditTemplate               = require('../template/user/edit.hbs');
const forgotPasswordTemplate         = require('../template/user/forgot-password.hbs');
const errorTemplate                  = require('../template/error/error.hbs');
const quizzAllTemplate               = require('../template/quiz/question-list.hbs');
const quizzSearchTemplate               = require('../template/quiz/question-search.hbs');
const quizzResults               = require('../template/quiz/quiz-results.hbs');

// My page
const myPageReportTemplate           = require('../template/mypage/report.hbs');
const myPageScoreTemplate            = require('../template/mypage/score.hbs');
const myPageRankingTemplate          = require('../template/mypage/ranking.hbs');
const myPageRankingSubTemplate          = require('../template/mypage/ranking_sub.hbs');
const userInfoTemplate               = require('../template/user/info.hbs');

// Incorrect
const incorrectListTypeTemplate           = require('../template/incorrect/list-type.hbs');

// SUPPLEMENT
const supplementTemplate           = require('../template/supplement/supplement.hbs');

export function registerRoute() {
    var loginObj = new Login();
    var indexdbObj = new indexDB_Cl();
    var clientObj = new ClientJS();
    /**
     * Check Exsit when login on other device
     * @type {ClientJs}
     */
    var client_Js = new client_JS();
    var device_token = client_Js.getInfoDevice();
    // client_Js.checkInfoDeviceLogin();
    
    /**
     * handle select type ranking of button ランク && 今週 on mypage 
     *
     * @author  ChienNguyen
     * @created 2019.01.12
     */
    var handleRanking = () => {
        $('.handle_ranking').click(function (e) {
            e.preventDefault();
            if ($(this).hasClass('select_top_100')) {
                // 
                $(this).removeClass('select_top_100').addClass('select_this_week').text('今週');
                if (navigator.onLine) {
                    document.getElementById("loadingOverlay").style.display = 'block';
                    $.ajax({
                        type: "POST",
                        url : config.url_api_get_top_100_this_week_learner,
                        data: {},
                        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                        success: function(data){
                            var result = [];
                            if(data.result == "OK"){
                                result = Base64.decode(data.response);
                            }
                            result = JSON.parse(result);
                            var output = myPageRankingSubTemplate({'result' : result, config: config, is_type_ranking : 'select_top_100'});
                            document.getElementById("rankingContent").innerHTML = output;
                            document.getElementById("loadingOverlay").style.display = 'none';
                        },
                        error: function (xhr, status) {
                            console.log('Call getLearnerListByRank error');
                            alert('サーバーエラーが発生しました');
                            document.getElementById("loadingOverlay").style.display = 'none';
                        }
                    });
                }

            } else {
                $(this).removeClass('select_this_week').addClass('select_top_100').text('ランク');
                if(navigator.onLine){
                    $.ajax({
                        type: "POST",
                        url : config.url_api_get_ranks,
                        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                        success: function(data){
                            if(data.response){
                                let rank_no = jsCookie.get('user_rank');
                                let learner_id = jsCookie.get('id_logged');
                                let learnerInfo = `{
                                "rank_no" : "${rank_no}",
                                "learner_id" : "${learner_id}"
                            }`;
                                $.ajax({
                                    type: "POST",
                                    url : config.url_api_get_leraner_list_by_rank,
                                    data: {'content' : Base64.encode(learnerInfo)},
                                    headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                                    success: function(data){
                                        var result = [];
                                        if(data.result == "OK"){
                                            result = Base64.decode(data.response);
                                        }
                                        result = JSON.parse(result);
                                        var output = myPageRankingSubTemplate({'result' : result, config: config, is_type_ranking : 'select_this_week'});
                                        document.getElementById("rankingContent").innerHTML = output;
                                        document.getElementById("loadingOverlay").style.display = 'none';
                                    },
                                    error: function (xhr, status) {
                                        console.log('Call getLearnerListByRank error');
                                        alert('サーバーエラーが発生しました');
                                        document.getElementById("loadingOverlay").style.display = 'none';
                                    }
                                });
                            }
                        },
                        error: function (xhr, status) {
                            console.log('Call url_api_get_ranks error');
                            alert('サーバーエラーが発生しました');
                            document.getElementById("loadingOverlay").style.display = 'none';
                        }
                    });
                }
            }
            funSound();
        });
    };

    /**
     * inner html
     *
     * @author  ChienNguyen
     * @created 18.12.2018
     */
    var innerHtmlCommon = (html, part) => {
        if($("#" + part).length)
        {
            $("#" + part).html(html);
        }
        return true;
    };
    
     /**
     * check sync data
     *
     * @author  ChienNguyen
     * @created 26.12.2018
     */
    var handleSyncData = () => {
         if(navigator.onLine) {
             Dexie.exists(config.DATE_NAME).then(function(exists) {
                 /**
                  * case is db exists
                  * check data from server
                  */
                 if (exists){

                    var packaged_sync = new Packaged_sync();
                    var syncDatas = new SyncData();
                    var list_data_client = packaged_sync.findAll();

                     list_data_client.then(function(list_data) {
                        var allDataForClient = [];
                        list_data.forEach(function(data,key){
                            // info include array id and version content
                            var info_data = [data.id, data.version];
                            allDataForClient.push(info_data);
                        });
                        let isLogin = loginObj.isLogged();
                        let learner_id = null;
                        let is_login = 0;
                        var organization_code = 0;
                        if(isLogin)
                        {
                            learner_id = is_login;
                            is_login = 1;
                            organization_code = jsCookie.get('organization_code');
                        }

                        let paramSyns = {
                            'is_login'   : is_login,
                            'learner_id'   : learner_id,
                            'organization_code' : organization_code,
                            'allDataForClient' : allDataForClient
                        };
                        var content = window.btoa(JSON.stringify(paramSyns));

                         //
                         $.ajax({
                             type: "POST",
                             url : config.url_api_check_data_on_server,
                             data: {'content' : content},
                             success: function(response){
                                 // if isset new data or isset update data
                                 //  if(response && response.result != 0)
                                 if(response && response.result != 0)
                                 {
                                    // set
                                    jsCookie.set('is_processing_sync', true, { expires: config.LIMIT_EXPIRES_CACHE });
                                    jsCookie.set('result_process_sync', 0, { expires: config.LIMIT_EXPIRES_CACHE });
                                    // call popup
                                    $('[data-popup="popup-hande-sync-data"]').fadeIn(350);

                                    // event close
                                    $('.popup-cl').click(function (e) {
                                        e.preventDefault();
                                        $('[data-popup="popup-hande-sync-data"]').fadeOut(350);
                                    });

                                    // event OK
                                    $('.handle-sync-data').click(function (e) {
                                         document.getElementById("loadingOverlay").style.display = 'block';
                                         $('[data-popup="popup-hande-sync-data"]').fadeOut(350);
                                         e.preventDefault();

                                        setTimeout(function(){
                                            syncDatas.handleSyncDataFromServer(isLogin, allDataForClient);
                                            // check process sync
                                            var check_process_sync = setInterval(function(){
                                                if(jsCookie.get('is_processing_sync') == (false).toString())
                                                {
                                                    syncDatas.updateInfoData();
                                                    if(parseInt(jsCookie.get('result_process_sync')) == config.CODE_SYNC_DATA.SYNC_COMPLETE && jsCookie.get('added_to_the_cache') == (true).toString())
                                                    {
                                                        clearInterval(check_process_sync);
                                                        $('[data-popup="popup-hande-sync-data"]').fadeOut(350);
                                                        alert(config.MESSAGE_HANDLE_SYNC_DATA.OK);
                                                        document.getElementById("loadingOverlay").style.display = 'none';

                                                    }else if(parseInt(jsCookie.get('result_process_sync')) != config.CODE_SYNC_DATA.SYNC_COMPLETE)
                                                    {
                                                        clearInterval(check_process_sync);
                                                        $('[data-popup="popup-hande-sync-data"]').fadeOut(350);
                                                        alert(config.MESSAGE_HANDLE_SYNC_DATA.NG);
                                                        document.getElementById("loadingOverlay").style.display = 'none';
                                                    }
                                                }
                                            },500);
                                        },500);
                                     });
                                 }
                             },
                             error: function (xhr, status) {
                                 console.log('Call saveSudyInfo error');
                             }
                         });
                     });
                 }
             });
         }
    };

 /**
     * import all handle before load page and acees page
     *
     * @param define_page_name string
     * @author  ChienNguyen
     * @created 2019.01.18
     */

    var commonHeaderFunct = (define_page_name) => {
        // 
        if(localStorage.getItem('quiz_question') && define_page_name != config.DEFINE_PAGE_NAME.QUIZ_ANSWER){
            let tmpquiz = JSON.parse(localStorage.getItem('quiz_question'));
            let tmpAccess = [];
            if(localStorage.getItem('ACCESS_QUIZ')){
                let tmpAccess = JSON.parse(localStorage.getItem('ACCESS_QUIZ'));
                let arrayQuizId = [];
                for (var i = 0; i < tmpAccess.length; i++) {
                    let key = tmpAccess[i];
                    let tmpkey = key.indexOf('_true');
                    if(tmpkey != -1){
                        // 
                        let quiz_id_array = key.split('_');
                        arrayQuizId.push(quiz_id_array[0]);
                        tmpAccess.splice(i, 1);
                    }
                }
                if(arrayQuizId.length){
                    db.open();
                    let recordObj       = new QuizRecorder();
                    recordObj.resetFaceMark(arrayQuizId);
                }
                localStorage.setItem('ACCESS_QUIZ', JSON.stringify(tmpAccess));
            }
        }

        // fix bug img for top
        if(define_page_name == config.DEFINE_PAGE_NAME.HOME)
        {
            document.getElementById("logoTop").style.display = 'block';


            // fix bug
            jsCookie.remove('is_active_incorrect_type');
        }
        else
        {
            document.getElementById("logoTop").style.display = 'none';
        }

        if (define_page_name == config.DEFINE_PAGE_NAME.MYPAGE_REPORT || define_page_name == config.DEFINE_PAGE_NAME.MYPAGE_RANKING ||
            // define_page_name == config.DEFINE_PAGE_NAME.QUIZ || define_page_name == config.DEFINE_PAGE_NAME.QUIZ_ANSWER ||
            define_page_name == config.DEFINE_PAGE_NAME.USER_MESSAGE ||
            define_page_name == config.DEFINE_PAGE_NAME.USER_CONFIG || define_page_name == config.DEFINE_PAGE_NAME.HOME)
        {
             // if(define_page_name == config.DEFINE_PAGE_NAME.MYPAGE_REPORT){
             //     localStorage.setItem('report', true);
             // } else {
             //     localStorage.setItem('report', false);
             // }
             // if(define_page_name == config.DEFINE_PAGE_NAME.MYPAGE_RANKING){
             //     localStorage.setItem('ranking', true);
             // } else {
             //     localStorage.setItem('ranking', false);
             // }

             isOffline(define_page_name);
        }

        // check setting for PWA  
        $.getJSON( config.subfolder + "/setting.json?v=" + new Date().getTime(), function( setting ) {

            // check auto clear cache for client
            if(setting.AUTO_CLEAR_CACHE && (typeof jsCookie.get('AUTO_CLEAR_CACHE') == "undefined" || (typeof jsCookie.get('AUTO_CLEAR_CACHE') != "undefined" && parseInt(jsCookie.get('AUTO_CLEAR_CACHE')) != setting.AUTO_CLEAR_CACHE)))
        {
            autoClearCache();
                jsCookie.set('AUTO_CLEAR_CACHE', parseInt(setting.AUTO_CLEAR_CACHE), { expires: config.LIMIT_EXPIRES_CACHE });
                var syncDatas = new SyncData();
                syncDatas.updateInfoData();
        }
        });



        
        
    };

    /**
     * import all handle alfter load page and acees page
     *
     * @param define_page_name string
     * @author  ChienNguyen
     * @created 26.12.2018
     */

    var commonFunct = (define_page_name) => {

        /**
         * Fix scroll after access page
         */
        window.scrollTo(0,0);

        /**
         * handle save study info 
         *
         * for page quiz && answer
         * @author  ChienNguyen
         * @Updated 07.01.2019
         */
        $('.handle_save_study_info').click(function () {
            var myPageObj = new Mypage();
            console.log("手動保存開始");
            myPageObj.saveStudyInfo();
        });

        // 
        // 
        if(localStorage.getItem('quiz_question') && define_page_name != config.DEFINE_PAGE_NAME.QUIZ_ANSWER){
            let tmpquiz = JSON.parse(localStorage.getItem('quiz_question'));
            let tmpAccess = [];
            if(localStorage.getItem('ACCESS_QUIZ')){
                tmpAccess = JSON.parse(localStorage.getItem('ACCESS_QUIZ'));
            }
            let key = tmpquiz.id + '_false';
            if(tmpAccess.indexOf(key) == -1){
                tmpAccess.push(key);
            }
            localStorage.setItem('ACCESS_QUIZ', JSON.stringify(tmpAccess));
        }

        /*
        *
        * 
        */
        functHandleSetFaceMark();

        // fix case img not reload on mobile 
        if(clientObj.isMobile()){
        	// console.log('iOS 11');
            $( "#contentBody img" ).each(function( index ) {
                $(this).attr('data-url', this.src).attr('onerror', config.MESSAGE_ONERROR);
                this.src = config.subfolder + '/img/loading-img.gif';
            });
            setTimeout(function(){ 
                $( "#contentBody img" ).each(function( index ) {
                    this.src =  $(this).attr('data-url');
                });
            }, 50);
        }


        // auto save study info when access answer
        if(define_page_name == config.DEFINE_PAGE_NAME.QUIZ_ANSWER && loginObj.isLogged()){
            if(typeof jsCookie.get('cookieAutoSaveCounts') != "undefined")
            {

                jsCookie.set('cookieAutoSaveCounts', parseInt(parseInt(jsCookie.get('cookieAutoSaveCounts')) + 1), { expires: config.LIMIT_EXPIRES_CACHE });
            }
            else
            {
                jsCookie.set('cookieAutoSaveCounts', 1, { expires: config.LIMIT_EXPIRES_CACHE });
            }
            if(jsCookie.get('cookieAutoSaveCounts') == config.autoSaveCounts){
                jsCookie.set('cookieAutoSaveCounts', 0, { expires: config.LIMIT_EXPIRES_CACHE });
                var myPageObj = new Mypage();
                var is_access_answer = true;
            console.log("自動保存開始");
                myPageObj.saveStudyInfo(is_access_answer);

                // add handle sync and create data by ChienNguyen 2019.02.19
                handleSyncData();
            }
        }

		//anti zoom on top page, fix iphone zoom out when login
        if(define_page_name == config.DEFINE_PAGE_NAME.HOME || define_page_name == config.DEFINE_PAGE_NAME.QUIZ_SEARCH){
            zoomDisable();
        }else{
            zoomEnable();
        }
        if(define_page_name == config.DEFINE_PAGE_NAME.HOME){
        	var btcss1 = document.getElementsByClassName("menu-category-list");
        	var btcss2 = document.getElementsByClassName("menu-mypage");
        	var btcss3 = document.getElementsByClassName("menu-service");
        	var btcss4 = document.getElementsByClassName("menu-incorrect");
        	var btcss5 = document.getElementsByClassName("menu-configuration-user");
        	var btcss6 = document.getElementsByClassName("menu-download");
        	//var btcss7 = document.getElementsByClassName("menu-login");
        	//var btcss8 = document.getElementsByClassName("menu-logout");
        	if(loginObj.isLogged()){
   				if(btcss1)	btcss1[0].style.background = "#a1a1a1";
   				if(btcss2)	btcss2[0].style.background = "#b1b1b1";
   				if(btcss3)	btcss3[0].style.background = "#a1a1a1";
   				if(btcss4)	btcss4[0].style.background = "#b1b1b1";
   				if(btcss5)	btcss5[0].style.background = "#a1a1a1";
   				if(btcss6)	btcss6[0].style.background = "#b1b1b1";
   				//btcss7[0].style.background = "#999";
   				//btcss8[0].style.background = "#999";
        	} else {
   				if(btcss1)	btcss1[0].style.background = "#40a140";
   				if(btcss2)	btcss2[0].style.background = "#40b140";
   				if(btcss3)	btcss3[0].style.background = "#40a140";
   				if(btcss4)	btcss4[0].style.background = "#40b140";
   				if(btcss5)	btcss5[0].style.background = "#40a140";
   				if(btcss6)	btcss6[0].style.background = "#40b140";
   				//btcss7[0].style.background = "#494";
   				//btcss8[0].style.background = "#494";
        	}
        }

        /*
        * add funct auto save leaning_logs
        *
        *
        * @author ChienNguyen
        * @updated 2019.01.15
        */
        if(loginObj.isLogged())
        {
        if(define_page_name == config.DEFINE_PAGE_NAME.QUIZ_ANSWER || define_page_name == config.DEFINE_PAGE_NAME.QUIZ){
            if(!IsJsonString(jsCookie.get('cookieAutoSaveLeaningLog')))
            {
                var date = new Date();
                let current_day = date.getFullYear() + "-" + (date.getMonth() + 1) + "-" + date.getDate();
                let current_time = date.getFullYear() + "-" + (date.getMonth() + 1) + "-" + date.getDate() + " " + date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds();
                var strLog = JSON.stringify(
                    {
                        'date' : current_day,
                        'time_start' : current_time
                    });
                        console.log("クイズ画面なので計測開始！"+define_page_name);
                jsCookie.set('cookieAutoSaveLeaningLog', strLog, { expires: config.LIMIT_EXPIRES_CACHE });
            }
        }
        else
        {
            if(IsJsonString(jsCookie.get('cookieAutoSaveLeaningLog')))
            {   var date = new Date();
                let tmpLearnLog = JSON.parse(jsCookie.get('cookieAutoSaveLeaningLog'));
                tmpLearnLog.time_end = date.getFullYear() + "-" + (date.getMonth() + 1) + "-" + date.getDate() + " " + date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds();
                var learningLog = new LearningLog();
                learningLog.add(tmpLearnLog).then(function (rs) {
                console.log("問題画面以外なので計測終了・保存"+define_page_name);
                    jsCookie.remove('cookieAutoSaveLeaningLog');
                });
                jsCookie.remove('cookieAutoSaveLeaningLog');
            }
        }
/*
        setInterval(function(){
            if(document.hidden)
            {
                if(IsJsonString(jsCookie.get('cookieAutoSaveLeaningLog')))
                {
                    var date = new Date();
                    let tmpLearnLog = JSON.parse(jsCookie.get('cookieAutoSaveLeaningLog'));
                    tmpLearnLog.time_end = date.getFullYear() + "-" + (date.getMonth() + 1) + "-" + date.getDate() + " " + date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds();
                    var learningLog = new LearningLog();
                    learningLog.add(tmpLearnLog).then(function (rs) {
                    console.log("タイマー：画面が隠れたので計測完了・保存"+define_page_name);
                        jsCookie.remove('cookieAutoSaveLeaningLog');
                    });
                    jsCookie.remove('cookieAutoSaveLeaningLog');
                }
            }
            else
            {
                if(define_page_name == config.DEFINE_PAGE_NAME.QUIZ_ANSWER || define_page_name == config.DEFINE_PAGE_NAME.QUIZ){
                    if(!IsJsonString(jsCookie.get('cookieAutoSaveLeaningLog') ))
                    {
                        var date = new Date();
                        let current_day = date.getFullYear() + "-" + (date.getMonth() + 1) + "-" + date.getDate();
                        let current_time = date.getFullYear() + "-" + (date.getMonth() + 1) + "-" + date.getDate() + " " + date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds();
                        var strLog = JSON.stringify(
                        {
                            'date' : current_day,
                            'time_start' : current_time
                        });
                        console.log("タイマー：クイズ画面なので計測開始！"+define_page_name);
                        jsCookie.set('cookieAutoSaveLeaningLog', strLog, { expires: config.LIMIT_EXPIRES_CACHE });
                    }
                }
            }
        },5000);

        // auto save study info follow setting time by ChienNguyen
        setInterval(function(){
            if(navigator.onLine)
            {
                if(jsCookie.get('cookieAutoSaveStudyInfo'))
                {
                    var current_date = new Date();
                    let setting_time_date = new Date(jsCookie.get('cookieAutoSaveStudyInfo'));
                    // sercon
                    var duration = (current_date.getTime() - setting_time_date.getTime())  / 1000;
                    if(duration >= config.autoSaveSettingTime)
                    {
                        var myPageObj = new Mypage();
                        var is_access_answer = true;
                                    console.log("自動保存開始（時間）");

                        myPageObj.saveStudyInfo(is_access_answer);
                    }

                }else{
                    var myPageObj = new Mypage();
                    var is_access_answer = true;
                                    console.log("自動保存開始（時間2）");
                   myPageObj.saveStudyInfo(is_access_answer);
                }
            }
        },config.autoSaveSettingTime * 1000);
*/
        }


        if (define_page_name != config.DEFINE_PAGE_NAME.MYPAGE_SCORE        && define_page_name != config.DEFINE_PAGE_NAME.MYPAGE_RANKING
            && define_page_name != config.DEFINE_PAGE_NAME.MYPAGE_REPORT
            && define_page_name != config.DEFINE_PAGE_NAME.USER_MESSAGE     && define_page_name != config.DEFINE_PAGE_NAME.USER_MESSAGE_ONE
            && define_page_name != config.DEFINE_PAGE_NAME.FORGOT_PASSWORD  && define_page_name != config.DEFINE_PAGE_NAME.USER_CONFIG
            && define_page_name != config.DEFINE_PAGE_NAME.USER_DETAIL
            )
        {
            if ($('div.add_audio').length) {
            } else {
                var audio = '<div class="add_audio"><audio hidden id="audio_ok" controls src="' + config.subfolder + '/sound/ok.m4a"></audio>\n' +
                    '<audio hidden id="audio_ng" controls src="' + config.subfolder + '/sound/ng.m4a"></audio>\n' +
                    '<audio hidden id="audio_click" controls src="' + config.subfolder + '/sound/click.m4a"></audio</div>';
                $('body').append(audio);
            }
        }

        if (define_page_name != config.DEFINE_PAGE_NAME.HOME && define_page_name != config.DEFINE_PAGE_NAME.CATEGORY_LIST_CATE &&
            define_page_name != config.DEFINE_PAGE_NAME.CATEGORY_LIST ) {
            if ('serviceWorker' in navigator && config.CACHEIMAGE) {
                var url = window.location;
                if (url) {
                    const staticCacheName = 'spp-pwa-precache-v' + config.version;
                    caches.open(staticCacheName).then(function(cache) {
                        return cache.add(url);
                    });
                }
            }
        }
    };

    /**
     * Check Is Mobile
     * @returns {boolean}
     */
    var isMobile = function isMobile() {
        return "ontouchstart" in window;
    };

    var isBrowser = function isBrowser() {
        if((navigator.userAgent.indexOf("Opera") || navigator.userAgent.indexOf('OPR')) != -1 ) {
            return 'Opera'
        } else if(navigator.userAgent.indexOf("Chrome") != -1 ) {
            return "Chrome"
        } else if(navigator.userAgent.indexOf("Safari") != -1) {
            return "Safari"
        } else if(navigator.userAgent.indexOf("Firefox") != -1 ) {
            return 'Firefox'
        }  else if((navigator.userAgent.indexOf("MSIE") != -1 ) || (!!document.documentMode == true )) { //IF IE > 10
            return 'IE'
        } else{
            return "unknown"
        }
    };

    // console.log(isBrowser());

    /**
     * Check Max size indexdb
     * @param db
     * @param dbName
     * @returns {Promise<any>}
     */
    var getTableSize = function(db, dbName){
        return new Promise((resolve,reject) => {
            if (db == null) {
                return reject();
            }
            var size = 0;
            // db = event.target.result;
            var transaction = db.transaction([dbName])
                .objectStore(dbName)
                .openCursor();

            transaction.onsuccess = function(event){
                var cursor = event.target.result;
                if(cursor){
                    var storedObject = cursor.value;
                    var json = JSON.stringify(storedObject);
                    size += json.length * 2;
                    cursor.continue();
                }
                else{
                    resolve(size);
                }
            }.bind(this);
            transaction.onerror = function(err){
                reject("error in " + dbName + ": " + err);
            }
        });
    };

    var getDatabaseSize = function (dbName) {
        var request = Dexie.exists(dbName).then(function(exists) {
            if (exists){
                // return indexedDB.open(dbName);
                var request = indexedDB.open(dbName);
                var db_;
                var dbSize = 0;
                request.onerror = function(event) {
                    alert("Why didn't you allow my web app to use IndexedDB?!");
                };
                request.onsuccess = function(event) {
                    db_ = event.target.result;
                    var tableNames = [ ...db_.objectStoreNames ];
                    (function(tableNames, db_) {
                        var tableSizeGetters = tableNames
                            .reduce( (acc, tableName) => {
                                acc.push( getTableSize(db_, tableName) );
                                return acc;
                            }, []);

                        Promise.all(tableSizeGetters)
                            .then(sizes => {
                                console.log('--------- Database name:' + db_.name + ' -------------');
                                // tableNames.forEach( (tableName,i) => {
                                //     console.log(" - " + tableName + "\t: " + humanReadableSize(sizes[i]));
                                // });
                                var total = sizes.reduce(function(acc, val) {
                                    return acc + val;
                                }, 0);

                                console.log("TOTAL: " + humanReadableSize(total))
                            });
                    })(tableNames, db_);
                };
            }
        });
        // var request = indexedDB.open(dbName);

    };

    var humanReadableSize = function (bytes) {
        var thresh = 1024;
        if(Math.abs(bytes) < thresh) {
            return bytes + ' B';
        }
        var units = ['KB','MB','GB','TB','PB','EB','ZB','YB'];
        var u = -1;
        do {
            bytes /= thresh;
            ++u;
        } while(Math.abs(bytes) >= thresh && u < units.length - 1);

        var browserName = isBrowser();
        var indexdb_browser;
        var decMobile = isMobile();
        var data_limit = 10;
        var notication = "";
        var show_mess = false;
        if (browserName != "unknown") {
            indexdb_browser = 'INDEXDB_' + browserName;
        } else {
            indexdb_browser = 'MEMORY_INDEXDB';
        }

        if (decMobile) {
            data_limit = config.DATA_LIMIT_MOBILE[indexdb_browser]
            notication = config.DATA_LIMIT_MOBILE.MOTICATION
        } else {
            data_limit = config.DATA_LIMIT_DESKTOP[indexdb_browser]
            notication = config.DATA_LIMIT_DESKTOP.MOTICATION
        }

        if (u == 1 && bytes > data_limit) {
            show_mess = true;
        } else {
            jsCookie.set('memory_limit', "OFF", { expires: config.LIMIT_EXPIRES_CACHE });
        }

        if (show_mess && jsCookie.get('memory_limit') == 'OFF'){
            jsCookie.set('memory_limit', "ON", { expires: config.LIMIT_EXPIRES_CACHE });
            alert(notication + data_limit + 'MB')
        }
        return bytes.toFixed(1)+' '+units[u];
    };

    /**
     * Function check status network
     */
    var isOffline = function isOffline(page) {
        if (navigator.onLine) {
            localStorage.setItem('TBD', true);
            localStorage.setItem('message_offline', 0);
        } else {
            localStorage.setItem('TBD', false);

            setTimeout(function () {
                // if (page === config.DEFINE_PAGE_NAME.MYPAGE_REPORT) {
                //     alert(config.NETWORK.OFFLINE_MYPAGE);
                // } else {
                    if (page == config.DEFINE_PAGE_NAME.USER_CONFIG) {
                        var message_offline = localStorage.getItem('message_offline');

                        if (message_offline == 0 || typeof message_offline == "undefined") {
                            alert(config.NETWORK.OFFLINE_PAGE);
                            localStorage.setItem('message_offline', 1);
                        }
                    } else {
                        localStorage.setItem('message_offline', 0);
                        alert(config.NETWORK.OFFLINE_PAGE);
                    }
                // }
            }, 500);
        }
    };

    page(config.subfolder, async (ctx) => {

        document.getElementById("loadingOverlay").style.display = 'none';

        // add list handle common header by ChienNguyen
        commonHeaderFunct(config.DEFINE_PAGE_NAME.HOME);
        var soundon = localStorage.getItem("soundon");

        if (loginObj.isLogged()) {
            client_Js.checkInfoDeviceLogin();
        }



        jsCookie.remove('quizmode');
        jsCookie.remove('random');
        db.open();
        var output = loginTemplate({config:config});
        var syncDatas = new SyncData();
        // document.clear();
        
        if(jsCookie.get('IS_ACCESS_FIRST') != (true).toString())
        {
            syncDatas.handleSyncDataFromServer(loginObj.isLogged(), []);
            jsCookie.set('IS_ACCESS_FIRST', true, { expires: config.LIMIT_EXPIRES_CACHE });
            
        }

        // inner html
        innerHtmlCommon(output, config.PART_CONTENT_HTML.CONTENT_BODY);

        $('.btn-login').on('click', function(e)  {
            if (navigator.onLine) {
                var targeted_popup_class = $(this).attr('data-popup-open');
                $('[data-popup="' + targeted_popup_class + '"]').fadeIn(350);
            } else {
                alert(config.NETWORK.OFFLINE_PAGE);
            }
            e.preventDefault();
            funSound();
        });

        //----- CLOSE
        $('[data-popup-close]').on('click', function(e) {
            if(loginObj.isLogged()){
                var targeted_popup_class = "popup-2";
            } else {
                var targeted_popup_class = $(this).attr('data-popup-close');
            }

            $('[data-popup="' + targeted_popup_class + '"]').fadeOut(350);
            e.preventDefault();
            funSound();
        });

        if(loginObj.isLogged()){
            $('#login').hide();
         	$('#logout').show();
        } else {
            $('#login').show();
            $('#logout').hide();
        }

        $('#logout').click(function (e) {
            e.preventDefault();
            if(loginObj.isLogged()){
                $('[data-popup="popup-2"]').fadeIn(350);
            }
            funSound();
        });

        $('.progress-logout').click(function (e) {
            loginObj.logout();
            if (navigator.onLine) {
                $('#login').show();
                $('#logout').hide();
            }
            $('[data-popup="popup-2"]').fadeOut(350);

            e.preventDefault();
            funSound();
        });

        $('.progress-cancle, .popup-close').click(function (e) {
            e.preventDefault();
            $('[data-popup="popup-2"]').fadeOut(350);
            funSound();
        });

        $('.progress-can, .popup-cl').click(function (e) {
            e.preventDefault();

            $('[data-popup="popup-message"]').fadeOut(350);
            funSound();
        });

        // add handle sync and create data by ChienNguyen 08.01.2019
        handleSyncData();
       
        $('#ajax_checkdata_loading').css("display", "none");

        if(isCategorynull == "1"){
            $('.btn-login').trigger('click');
        }

        getDatabaseSize(config.DATE_NAME);

        $(document).on('submit','form.login',function(event ){
            funSound();
            var email_address = $('#LoginUserName').val();
            var password = $('#LoginPass').val();
            loginObj.login(email_address, password);
            event.preventDefault();

        });

        $('.menu_action').click(function ()  {
            var data_sync_seccess = jsCookie.get('data_sync_seccess');
            var data = $(this).data('id');

            if(data_sync_seccess != 'true'){
                $('[data-popup="popup-1"]').fadeIn(350);
                return false;
            } else {
                if (data == 'list') {
                    page.redirect(config.subfolder + '/category/list-cat');
                } else if (data == 'mypage'){
                    page.redirect(config.subfolder + '/mypage/report');
                } else if (data == 'incorrect'){
                    page.redirect(config.subfolder + '/incorrect/list-type');
                }

                if (data == 'configuration'){
                    if(!loginObj.isLogged()){
                        $('[data-popup="popup-1"]').fadeIn(350);
                        return false;
                    } else {
                        page.redirect(config.subfolder + '/user/configuration');
                    }
                }
            }
        });


        var messageObj = new Message();
        var learner_id = jsCookie.get('id_logged');
        if(loginObj.isLogged()){
            syncDatas.getMessageList(learner_id, "top");
        }

        // add list handle common by ChienNguyen
        commonFunct(config.DEFINE_PAGE_NAME.HOME);

        soundFunction();

    });

    page(config.subfolder + '/category/list-cat', async function(ctx) {
        document.getElementById("loadingOverlay").style.display = 'block';
        var soundon = localStorage.getItem("soundon");

        // add list handle common header by ChienNguyen
        commonHeaderFunct(config.DEFINE_PAGE_NAME.CATEGORY_LIST_CATE);


        var output = categoryListTemplate({bigCategories: [], config: config});
        // inner html
        innerHtmlCommon(output, config.PART_CONTENT_HTML.CONTENT_BODY);

        if (loginObj.isLogged()) {
            client_Js.checkInfoDeviceLogin();
        }
        var categoryNo    = 0;
        var syncDatas = new SyncData();
        var categoryObj = new Category();
        var quizObj = new Quiz();
        jsCookie.remove('quizmode');
        jsCookie.remove('random');

        var bigCategories = await categoryObj.getCategoriesList(categoryNo);
        if(bigCategories.length == 0){
            // alert('ログインして下さい。');
            page.redirect(config.subfolder);
            return true
        }

        var quizObj     = new Quiz();
        let info_use_set_active = {};
        if(jsCookie.get('info_use_set_active')){
            info_use_set_active =  JSON.parse(jsCookie.get('info_use_set_active'));
        }

        var output = categoryListTemplate({bigCategories: bigCategories, config: config, info_use_set_active: info_use_set_active});

         // inner html
        innerHtmlCommon(output, config.PART_CONTENT_HTML.CONTENT_BODY);

        // 
        document.getElementById("loadingOverlay").style.display = 'none';

        //sound
        soundFunction();
        // start random
        $('.popup-random').click(function (e) {
            jsCookie.set('answerNote', "off", { expires: config.LIMIT_EXPIRES_CACHE });
            jsCookie.set('randomNote', "on", { expires: config.LIMIT_EXPIRES_CACHE });
            jsCookie.set('randomTotalCorrect', 0, { expires: config.LIMIT_EXPIRES_CACHE });
            jsCookie.set('randomTotalError', 0, { expires: config.LIMIT_EXPIRES_CACHE });

            var dataCategory = $(this).data('id');
            var bigCategory = $(this).data('bigcategory');
            var totalQuizOfSubCategory = $(this).data('quiz');
            if (parseInt(totalQuizOfSubCategory) > 0) {
                $('#quizRange').attr('max', totalQuizOfSubCategory);
                $('#quizRange').val(totalQuizOfSubCategory);
                $('#ageOutputId').text(totalQuizOfSubCategory);
            }
            $('[data-popup="popup-random"]').fadeIn(350);
            $('#random_category_no').val(dataCategory);
            $('#random_category_no').attr('data-bigcategory', bigCategory);
            e.preventDefault();

        });

        $('.proccess-random-quiz').click(function (e) {
            e.preventDefault();
            var quizRange = $('#quizRange').val();
            var random_category_no = $('#random_category_no').val();

            quizObj.getRandomRangeMode(random_category_no, quizRange);

            var bigcategory = $('#random_category_no').data('bigcategory');
            // jsCookie.set('category_random_mode', random_category_no + '-' + bigcategory, { expires: config.LIMIT_EXPIRES_CACHE });
        });

        $('#switchAnswerNote #toggleAnswerNote').click(function(){
            if ($('#toggleAnswerNote').is(':checked')) {
                jsCookie.set('answerNote', "on", { expires: config.LIMIT_EXPIRES_CACHE });
                jsCookie.set('randomNote', "off", { expires: config.LIMIT_EXPIRES_CACHE });
                if ($('#toggleNote').is(':checked')) {
                    $('#toggleNote').removeAttr('checked');
                    $('#toggleNote').click();
                }
            }else{
                jsCookie.set('answerNote', "off", { expires: config.LIMIT_EXPIRES_CACHE });
            }
        });

        $('#switchNote #toggleNote').click(function(){

            if ($('#toggleNote').is(':checked')) {
                jsCookie.set('answerNote', "off", { expires: config.LIMIT_EXPIRES_CACHE });
                jsCookie.set('randomNote', "on", { expires: config.LIMIT_EXPIRES_CACHE });

                if ($('#toggleAnswerNote').is(':checked')) {
                    $('#toggleAnswerNote').removeAttr('checked');
                    $('#toggleAnswerNote').click();
                }
            }else{
                jsCookie.set('randomNote', "off", { expires: config.LIMIT_EXPIRES_CACHE });
            }
        });

        $('#toggleNote').click();

        //Start sheet
        $('.popup-sheet').click(function (e) {
            $('[data-popup="popup-sheet"]').fadeIn(350);
            var data = $(this).data();
            e.preventDefault();
            
            $('.red-sheet-all-quiz').attr('data-url', data['url']);
            $('.red-sheet-all-quiz').attr('data-cat', data['id']);
            $('.red-sheet-bookmark-quiz').attr('data-cat', data['id']);
            $('.red-sheet-bookmark-quiz').attr('data-url', data['bookmark']);
        });
        
        $('.red-sheet-all-quiz, .red-sheet-bookmark-quiz').click(function (e) {
            e.preventDefault();

            var data = $(this).data();
            var url = $(this).data('url');

            if (data['id'] == 'sheet') {
                jsCookie.set('randomTotalCorrect', 0, { expires: config.LIMIT_EXPIRES_CACHE });
                jsCookie.set('randomTotalError', 0, { expires: config.LIMIT_EXPIRES_CACHE });
                var category = data['cat'];
                quizObj.getAllQuizRedSheet (category, url);
                return true;
            } else {
                jsCookie.set('quizmode', 'red-bookmark', { expires: config.LIMIT_EXPIRES_CACHE });
                var category = data['cat'];
                quizObj.getAllQuizRedBookmark (category, url);
                return true;
            }
        });
        //end sheet

        $('.selectCategory').on('change', function () {
            var categoryNo = $(this).val();
            page.redirect(config.subfolder + '/category/list-cat/' + [categoryNo].join('/'));
        });

        $(".tgt .nav-toggle").click(function(e) {
            var collapse_content_selector = $(this).data('rel');
            var x = document.getElementById(collapse_content_selector);

            $('.toggle-main').addClass('unactive').removeClass('active');
            $('#' + collapse_content_selector).addClass('active').removeClass('unactive');

            $('#' + collapse_content_selector ).toggle(function(){
                $(this).css('display')=='none'
            });
            $('.toggle-main.unactive').hide();

            e.preventDefault();
        });

        $("#all_ques .toggle-link .nav-toggle").click(function(e) {
            var collapse_content_selector = $(this).data('rel');

            $('.sublist.toggle-main').addClass('unactive').removeClass('active');
            $('#' + collapse_content_selector).addClass('active').removeClass('unactive');

            // $('#all_ques .sublist').hide();
            $('#' + collapse_content_selector).toggle(function(){
                $(this).css('display')=='none';
                
            });
            $('.sublist.toggle-main.unactive').hide();
            e.preventDefault();
        });

        $('.progress-cancle, .popup-close').click(function (e) {
            $('[data-popup="popup-random"]').fadeOut(350);
            $('[data-popup="popup-sheet"]').fadeOut(350);
            $('[data-popup="popup-message"]').fadeOut(350);
            e.preventDefault();
        });

        // set active section
        $('.layer1 .cate_active').parent().parent().parent().parent().find('nav.list').toggle("slide");

        $('.toggle .sub_active') .parent().parent().parent('div').find('div.sublist').toggle("slide");

        // clear
        jsCookie.remove('info_use_set_active');

        // 
        jsCookie.set('is_url_back', config.DEFINE_PAGE_NAME.CATEGORY_LIST_CATE, { expires: config.LIMIT_EXPIRES_CACHE });

        soundFunction();

        // add list handle common by ChienNguyen
        commonFunct(config.DEFINE_PAGE_NAME.CATEGORY_LIST_CATE);

        $('a').click(function (e) {
            if ($(this).parent().hasClass('back')) {
                funSound();
            }
        });



    });

    page(config.subfolder + '/category/list/:categoryNo?', async function(ctx) {
        var soundon = localStorage.getItem("soundon");

        // add list handle common header by ChienNguyen
        commonHeaderFunct(config.DEFINE_PAGE_NAME.CATEGORY_LIST);

        // client_Js.checkInfoDeviceLogin();
        var categoryNo    = 0;
        var syncDatas = new SyncData();
        var categoryObj = new Category();
        var quizObj = new Quiz();
        jsCookie.remove('quizmode');
        jsCookie.remove('random');

        var bigCategories = await categoryObj.getCategoriesList(categoryNo);
        if(bigCategories.length == 0){
            alert('ログインして下さい。');
            page.redirect(config.subfolder);
            return true
        }

        var quizObj     = new Quiz();
        var output = categoryListTemplate({bigCategories: bigCategories, config: config});

        // inner html
        innerHtmlCommon(output, config.PART_CONTENT_HTML.CONTENT_BODY);

        // start random
        $('.popup-random').click(function (e) {
            jsCookie.set('answerNote', "off", { expires: config.LIMIT_EXPIRES_CACHE });
            jsCookie.set('randomNote', "on", { expires: config.LIMIT_EXPIRES_CACHE });
            jsCookie.set('randomTotalCorrect', 0, { expires: config.LIMIT_EXPIRES_CACHE });
            jsCookie.set('randomTotalError', 0, { expires: config.LIMIT_EXPIRES_CACHE });

            var dataCategory = $(this).data('id');
            var totalQuizOfSubCategory = $(this).data('quiz');
            if (parseInt(totalQuizOfSubCategory) > 0) {
                $('#quizRange').attr('max', totalQuizOfSubCategory);
                $('#quizRange').val(totalQuizOfSubCategory);
                $('#ageOutputId').text(totalQuizOfSubCategory);
            }
            $('[data-popup="popup-random"]').fadeIn(350);
            $('#random_category_no').val(dataCategory);

            e.preventDefault();
        });

        $('.proccess-random-quiz').click(function (e) {
            e.preventDefault();
            var quizRange = $('#quizRange').val();
            var random_category_no = $('#random_category_no').val();

            quizObj.getRandomRangeMode(random_category_no, quizRange);

        });


        $('#switchAnswerNote input[type="checkbox"]').click(function(){
            if ($('#toggleAnswerNote').is(':checked')) {
                jsCookie.set('answerNote', "on", { expires: config.LIMIT_EXPIRES_CACHE });
                jsCookie.set('randomNote', "off", { expires: config.LIMIT_EXPIRES_CACHE });
                if ($('#toggleNote').is(':checked')) {
                    $('#toggleNote').removeAttr('checked');
                    $('#toggleNote').click();
                }
            }else{
                jsCookie.set('answerNote', "off", { expires: config.LIMIT_EXPIRES_CACHE });
            }
        });

        $('#switchNote input[type="checkbox"]').click(function(){
            if ($('#toggleNote').is(':checked')) {
                jsCookie.set('answerNote', "off", { expires: config.LIMIT_EXPIRES_CACHE });
                jsCookie.set('randomNote', "on", { expires: config.LIMIT_EXPIRES_CACHE });

                if ($('#toggleAnswerNote').is(':checked')) {
                    $('#toggleAnswerNote').removeAttr('checked');
                    $('#toggleAnswerNote').click();
                }
            }else{
                jsCookie.set('randomNote', "off", { expires: config.LIMIT_EXPIRES_CACHE });
            }
        });

        var category_random_mode = jsCookie.get('category_random_mode');
        if (typeof category_random_mode != "undefined" && category_random_mode != '-') {
            var collapse_content = category_random_mode;
            var array = collapse_content.split('-');
            // var collapse_content_selector = 'quest' + 501;

            $('.toggle-main').addClass('unactive').removeClass('active');
            $('#listsub' + array[1]).addClass('active').removeClass('unactive');

            $('.sublist.toggle-main').addClass('unactive').removeClass('active');
            $('#quest' + array[0]).addClass('active').removeClass('unactive');

            $('#listsub' + array[1]).toggle(function(){
                $(this).css('display')=='none';
            });

            $('#quest' + array[0]).toggle(function(){
                $(this).css('display')=='none';
            });

            $('.sublist.toggle-main.unactive').hide();
            jsCookie.remove('category_random_mode');
        }

        // End random

        //Start sheet
        $('.popup-sheet').click(function (e) {
            $('[data-popup="popup-sheet"]').fadeIn(350);
            var data = $(this).data();
            e.preventDefault();

            $('.red-sheet-all-quiz').attr('data-url', data['url']);
            $('.red-sheet-bookmark-quiz').attr('data-url', data['bookmark']);
        });

        $('.red-sheet-all-quiz, .red-sheet-bookmark-quiz').click(function (e) {
            var data = $(this).data();
            if (data['id'] == 'sheet') {
                jsCookie.set('randomTotalCorrect', 0, { expires: config.LIMIT_EXPIRES_CACHE });
                jsCookie.set('randomTotalError', 0, { expires: config.LIMIT_EXPIRES_CACHE });
            } else if (data['id'] == 'bookmark') {
                jsCookie.set('quizmode', 'red-bookmark', { expires: config.LIMIT_EXPIRES_CACHE });
            }

            var url = $(this).data('url');

            return page.redirect(url);
        });

        //end sheet

        $('.selectCategory').on('change', function () {
            var categoryNo = $(this).val();
            page.redirect(config.subfolder + '/category/list-cat/' + [categoryNo].join('/'));
        });

        $(".tgt .nav-toggle").click(function(e) {
            var collapse_content_selector = $(this).data('rel');
            var x = document.getElementById(collapse_content_selector);

            $('.toggle-main').addClass('unactive').removeClass('active');
            $('#' + collapse_content_selector).addClass('active').removeClass('unactive');

            $('#' + collapse_content_selector ).toggle(function(){
                $(this).css('display')=='none'
            });
            $('.toggle-main.unactive').hide();

            e.preventDefault();
        });

        $("#all_ques .toggle-link .nav-toggle").click(function(e) {
            var collapse_content_selector = $(this).data('rel');

            $('.sublist.toggle-main').addClass('unactive').removeClass('active');
            $('#' + collapse_content_selector).addClass('active').removeClass('unactive');

            // $('#all_ques .sublist').hide();
            $('#' + collapse_content_selector).toggle(function(){
                $(this).css('display')=='none';

            });
            $('.sublist.toggle-main.unactive').hide();
            e.preventDefault();
        });

        $('.progress-cancle, .popup-close').click(function (e) {
            $('[data-popup="popup-random"]').fadeOut(350);
            $('[data-popup="popup-sheet"]').fadeOut(350);
            e.preventDefault();
        });

        soundFunction();

        // add list handle common by ChienNguyen
        commonFunct(config.DEFINE_PAGE_NAME.CATEGORY_LIST);
    });

    page(config.subfolder + '/category/normal/:categoryNo?', async function(ctx) {
        // add list handle common header by ChienNguyen
        commonHeaderFunct(config.DEFINE_PAGE_NAME.CATEGORY_NORMAL);
        var soundon = localStorage.getItem("soundon");


        // client_Js.checkInfoDeviceLogin();
        var categoryNo    = parseInt(ctx.params.categoryNo);
        var categoryObj = new Category();
        jsCookie.remove('quizmode');
        jsCookie.remove('random');

        if (isNaN(categoryNo)) {
            categoryNo = 0;
        }

        var categories = await categoryObj.getCategoriesList(categoryNo);

        var output = categoryListTemplate({categories: categories, config: config});

        // inner html
        innerHtmlCommon(output, config.PART_CONTENT_HTML.CONTENT_BODY);

        $('.selectCategory').on('change', function () {
            var categoryNo = $(this).val();
            page.redirect(config.subfolder + '/category/list-cat/' + [categoryNo].join('/'));
        });

        $('.nav-toggle').click(function() {
            var selector = $(this).data('id');
            $(selector).toggle( function () {
                $(this).css('display')=='none';
            });
        });

        soundFunction();

        // add list handle common by ChienNguyen
        commonFunct(config.DEFINE_PAGE_NAME.CATEGORY_NORMAL);
    });

    page(config.subfolder + '/category/continue/:categoryNo?', async function(ctx) {
        // add list handle common header by ChienNguyen
        commonHeaderFunct(config.DEFINE_PAGE_NAME.CATEGORY_CONTINUE);
        var soundon = localStorage.getItem("soundon");

        // client_Js.checkInfoDeviceLogin();
        var categoryNo    = parseInt(ctx.params.categoryNo);
        var categoryObj = new Category();
        var continueObj = new Continue();
        var continueQiuz = await continueObj.find();
        jsCookie.remove('quizmode');
        jsCookie.remove('random');

        if (typeof continueQiuz !== 'undefined'){
            var categories = await categoryObj.getCategoriesContinueQuizzes(continueQiuz);
        } else {
            var categories = await categoryObj.getCategoriesHaveAnsweredQuizzes();
        }

        var output = categoryContinueTemplate({categories: categories, config: config});

         // inner html
        innerHtmlCommon(output, config.PART_CONTENT_HTML.CONTENT_BODY);

        $('.selectCategory').on('change', function () {
            var categoryNo = $(this).val();
            page.redirect(config.subfolder + '/category/list-cat/' + [categoryNo].join('/'));
        });

        $('.nav-toggle').click(function() {
            var selector = $(this).data('id');
            $(selector).toggle();
        });

        soundFunction();

        // add list handle common by ChienNguyen
        commonFunct(config.DEFINE_PAGE_NAME.CATEGORY_CONTINUE);
    });

    page(config.subfolder + '/category/incorrect/:categoryNo?', async function(ctx) {
        var soundon = localStorage.getItem("soundon");
        // add list handle common header by ChienNguyen
        commonHeaderFunct(config.DEFINE_PAGE_NAME.CATEGORY_INCORRECT);

        // client_Js.checkInfoDeviceLogin();
        var categoryNo    = parseInt(ctx.params.categoryNo);
        var categoryObj = new Category();
        jsCookie.remove('quizmode');
        jsCookie.remove('random');

        if (isNaN(categoryNo)) {
            categoryNo = 0;
        }
        var categories = await categoryObj.getCategoriesHaveIncorrectAnsweredQuizzes(categoryNo);
        var output = categoryIncorrectTemplate({categories: categories, config: config});
       

        // inner html
        innerHtmlCommon(output, config.PART_CONTENT_HTML.CONTENT_BODY);

        $('.selectCategory').on('change', function () {
            var categoryNo = $(this).val();
            page.redirect(config.subfolder + '/category/list-cat/' + [categoryNo].join('/'));
        });

        $('.nav-toggle').click(function() {
            var selector = $(this).data('id');
            $(selector).toggle();
        });
        soundFunction();

        // add list handle common by ChienNguyen
        commonFunct(config.DEFINE_PAGE_NAME.CATEGORY_INCORRECT);
    });

    page(config.subfolder + '/category/not-answered-yet/:categoryNo?', async function(ctx) {
        var soundon = localStorage.getItem("soundon");
        // add list handle common header by ChienNguyen
        commonHeaderFunct(config.DEFINE_PAGE_NAME.CATEGORY_NOT_ANSWERED_YET);

        // client_Js.checkInfoDeviceLogin();
        var categoryNo    = parseInt(ctx.params.categoryNo);
        var categoryObj = new Category();
        jsCookie.remove('quizmode');
        jsCookie.remove('random');

        if (isNaN(categoryNo)) {
            categoryNo = 0;
        }
        var categories = await categoryObj.getCategoriesHaveUnansweredQuizzes(categoryNo);
        var output = categoryNotAnsweredYetTemplate({categories: categories, config: config});

        // inner html
        innerHtmlCommon(output, config.PART_CONTENT_HTML.CONTENT_BODY);

        $('.selectCategory').on('change', function () {
            var categoryNo = $(this).val();
            page.redirect(config.subfolder + '/category/list-cat/' + [categoryNo].join('/'));
        });

        $('.nav-toggle').click(function() {
            var selector = $(this).data('id');
            $(selector).toggle();
        });

        soundFunction();
        // add list handle common by ChienNguyen
        commonFunct(config.DEFINE_PAGE_NAME.CATEGORY_NOT_ANSWERED_YET);
    });

    page(config.subfolder + '/category/bookmark/:categoryNo?', async function(ctx) {
        // add list handle common header by ChienNguyen
        commonHeaderFunct(config.DEFINE_PAGE_NAME.CATEGORY_BOOKMARK);
        var soundon = localStorage.getItem("soundon");

        // client_Js.checkInfoDeviceLogin();
        var categoryNo    = parseInt(ctx.params.categoryNo);
        var categoryObj = new Category();
        jsCookie.remove('quizmode');
        jsCookie.remove('random');

        if (isNaN(categoryNo)) {
            categoryNo = 0;
        }

        var categories = await categoryObj.getCategoriesHaveBookmarkQuizzes(categoryNo);
        var output = categoryBookmarkTemplate({categories: categories, config: config});

         // inner html
        innerHtmlCommon(output, config.PART_CONTENT_HTML.CONTENT_BODY);

        $('.selectCategory').on('change', function () {
            var categoryNo = $(this).val();
            page.redirect(config.subfolder + '/category/list-cat/' + [categoryNo].join('/'));
        });

        $('.nav-toggle').click(function() {
            var selector = $(this).data('id');
            $(selector).toggle();
        });

        soundFunction();
        // add list handle common by ChienNguyen
        commonFunct(config.DEFINE_PAGE_NAME.CATEGORY_BOOKMARK);

    });

    page(config.subfolder + '/category/random/:categoryNo?', async function(ctx) {
        // add list handle common header by ChienNguyen
        commonHeaderFunct(config.DEFINE_PAGE_NAME.CATEGORY_RANDOM);
        var soundon = localStorage.getItem("soundon");

        // client_Js.checkInfoDeviceLogin();
        var categoryNo    = parseInt(ctx.params.categoryNo);
        var categoryObj = new Category();
        jsCookie.remove('quizmode');

        if (isNaN(categoryNo)) {
            categoryNo = 0;
        }

        // var categories = await categoryObj.getAllCategories(categoryNo);
        var categories = await categoryObj.getAllCategoriesRandom(categoryNo);
        var output = categoryRandomTemplate({categories: categories, config: config});

         // inner html
        innerHtmlCommon(output, config.PART_CONTENT_HTML.CONTENT_BODY);

        $('.selectCategory').on('change', function () {
            var categoryNo = $(this).val();
            page.redirect(config.subfolder + '/category/list-cat/' + [categoryNo].join('/'));
        });

        $('.nav-toggle').click(function() {
            var selector = $(this).data('id');
            $(selector).toggle();
        });

        soundFunction();

        // add list handle common by ChienNguyen
        commonFunct(config.DEFINE_PAGE_NAME.CATEGORY_RANDOM);
    });

    page(config.subfolder + '/category/red-sheet/:categoryNo?', async function(ctx) {
        // add list handle common header by ChienNguyen
        commonHeaderFunct(config.DEFINE_PAGE_NAME.CATEGORY_RED_SHEET);
        var soundon = localStorage.getItem("soundon");

        // client_Js.checkInfoDeviceLogin();
        var categoryNo    = parseInt(ctx.params.categoryNo);
        var categoryObj = new Category();
        jsCookie.remove('quizmode');
        jsCookie.remove('random');

        if (isNaN(categoryNo)) {
            categoryNo = 0;
        }
        var categories = await categoryObj.getAllCategoriesRandom(categoryNo);
        var output = categoryRedSheetTemplate({categories: categories, config: config});
         // inner html
        innerHtmlCommon(output, config.PART_CONTENT_HTML.CONTENT_BODY);

        $('.selectCategory').on('change', function () {
            var categoryNo = $(this).val();
            page.redirect(config.subfolder + '/category/list-cat/' + [categoryNo].join('/'));
        });

        $('.nav-toggle').click(function() {
            var selector = $(this).data('id');
            $(selector).toggle();
        });
        soundFunction();

        // add list handle common by ChienNguyen
        commonFunct(config.DEFINE_PAGE_NAME.CATEGORY_RED_SHEET);
    });

    //question-list

    page(config.subfolder + '/quiz-all/:categoryNo/:subCategoryNo?', async (ctx) => {

        // window.onbeforeunload = function(event)
        // {
        //     if (!navigator.onLine){
        //         return confirm("reload page");
        //     }
        // };
        // add list handle common header by ChienNguyen
        commonHeaderFunct(config.DEFINE_PAGE_NAME.QUIZ_ALL);
        var soundon = localStorage.getItem("soundon");

        // client_Js.checkInfoDeviceLogin();
        var categoryNo    = parseInt(ctx.params.categoryNo);
        var subCategoryNo = parseInt(ctx.params.subCategoryNo);
        jsCookie.remove('quizmode');
        jsCookie.remove('random');

        var categoryObj = new Category();
        let recordObj       = new QuizRecorder();

        var quiz;
        var category = await categoryObj.findByCategoryAndSubCategoryNo(categoryNo, subCategoryNo);
        var output;
        var templateParams = {
            category: category,
            subfolder: config.subfolder,
        };
        quiz = await categoryObj.getQuizzesall(categoryNo, subCategoryNo);

        // let incorrect_quiz      = await recordObj.findAll();
        templateParams.quiz = quiz;
        templateParams.quiz.forEach(function(el,key){
            el.sfolder = config.subfolder;
            el.pageCount = key+1;
            let tmp = el.sentence;
            if(tmp.replace('&lt;MULTI_ANSWER_TAG&gt;', '').substring(0, 15).split('<')[0])
            {
                el.sentence = el.sentence.replace('&lt;MULTI_ANSWER_TAG&gt;', '').substring(0, 15).split('<')[0];
            }
            else
            {
                el.sentence = el.sentence.replace(/(<([^>]+)>)/ig,"").substring(0, 15);
            }
        });

        var output = quizzAllTemplate(templateParams);

         // inner html
        innerHtmlCommon(output, config.PART_CONTENT_HTML.CONTENT_BODY);

        $('#show-all-quiz').css("display", "none");
        $('#sort-bookmark').on("click",(function(){
            $('.allquiz a.bt-bookmark').parent().toggle('hide');
            $('#show-all-quiz').css("display", "block");
            $(this).css("display", "none");
        }));

        $('#show-all-quiz').on("click",(function(){
            $('.allquiz a.bt-bookmark').parent().toggle('show');
            $('#sort-bookmark').css("display", "block");
            $(this).css("display", "none");
        }));

        $('#searchButton').on("click",(function(){
            $('#searchButton').css("display", "none");
            $('#qInput').css("display", "block");
        }));
        $('#qInput').keyup(function () {
            var input, filter, ul, li, a, i;
            input = document.getElementById('qInput');
            filter = input.value.toUpperCase();
            ul = document.getElementById("sec1");
            li = ul.getElementsByTagName("li");
            for (i = 0; i < li.length; i++) {
                a = li[i].getElementsByTagName("a")[0];
                if (a.innerHTML.toUpperCase().indexOf(filter) > -1) {
                    li[i].style.display = "";
                } else {
                    li[i].style.display = "none";
                }
            }
        });

        // set cookie use active category on page cate list
        let info_use_set_active = JSON.stringify(
            {   
                category_no : categoryNo,
                sub_category_no : subCategoryNo
            });

        jsCookie.set('info_use_set_active', info_use_set_active, { expires: config.LIMIT_EXPIRES_CACHE });

        soundFunction();

        // 
        jsCookie.set('is_url_back', config.DEFINE_PAGE_NAME.QUIZ_ALL, { expires: config.LIMIT_EXPIRES_CACHE });

        // add list handle common by ChienNguyen
        commonFunct(config.DEFINE_PAGE_NAME.QUIZ_ALL);
    });

    page(config.subfolder + '/search', async (ctx) => {
        // add list handle common header by ChienNguyen
        commonHeaderFunct(config.DEFINE_PAGE_NAME.QUIZ_ALL);
        var soundon = localStorage.getItem("soundon");


        // client_Js.checkInfoDeviceLogin();
        jsCookie.remove('quizmode');
        jsCookie.remove('random');
        let quizRepo = new Quiz();

        var output;
        var templateParams = {
            config: config,
        };

        var output = quizzSearchTemplate(templateParams);

         // inner html
        innerHtmlCommon(output, config.PART_CONTENT_HTML.CONTENT_BODY);

        $('.question-search').toggle('hide');

        $('#show-all-quiz').css("display", "none");
        $('#sort-bookmark').on("click",(function(){
            $('.allquiz a.bt-bookmark').parent().toggle('hide');
            $('#show-all-quiz').css("display", "block");
            $(this).css("display", "none");
        }));
        
        //prevent enter
        $("#qInput").keypress(function(event) {
            if (event.keyCode == 13) {
                event.preventDefault();
                return false;
            }
        });
        
        $('#qInput').keyup(function () {
            var input = document.getElementById('qInput');
            jsCookie.set('list_search', 'OFF', { expires: config.LIMIT_EXPIRES_CACHE });
            input = input.value.trim();
            if(input == ""){
                $('#sec1').html("");
            }else{
                var quizs = quizRepo.quizzesSearch(input.toUpperCase());
                quizs.then(function(results) {

                    var tmpResultsParams = {
                        config: config,
                    };
                    tmpResultsParams.quiz = results;
                    quizRepo.getSearchList(results);

                    var output_results = quizzResults(tmpResultsParams);
                    // $('#sec1').html(output_results);
                });

                jsCookie.set('list_search', 'ON', { expires: config.LIMIT_EXPIRES_CACHE });
                var keywork = $('#qInput').val();
                jsCookie.set('keywork_search', keywork, { expires: config.LIMIT_EXPIRES_CACHE });
            }
        });

        var keyworksearch = jsCookie.get('keywork_search');
        var statussearch = jsCookie.get('list_search');

        if (typeof keyworksearch != "undefined" && statussearch == "ON") {
           $('#qInput').val(keyworksearch).keyup();
        }

        soundFunction();

        // add list handle common by ChienNguyen
        commonFunct(config.DEFINE_PAGE_NAME.QUIZ_SEARCH);
    });

    //end question-list

    page(config.subfolder + '/quiz/:mode/:categoryNo/:subCategoryNo?/:quizNo?', async (ctx) => {
        // add list handle common header by ChienNguyen
        commonHeaderFunct(config.DEFINE_PAGE_NAME.QUIZ);
        var soundon = localStorage.getItem("soundon");

        // client_Js.checkInfoDeviceLogin();
        var mode          = ctx.params.mode.toLowerCase();
        var categoryNo    = parseInt(ctx.params.categoryNo);
        var subCategoryNo = parseInt(ctx.params.subCategoryNo);
        var quizNo        = parseInt(ctx.params.quizNo);
        jsCookie.remove('startTimer');

        var quizObj     = new Quiz();
        var categoryObj = new Category();
        var continueQuiz    = new Continue();
        var randomQuiz    = new Random();


        var quiz;
        if (subCategoryNo != 0){
            var category = await categoryObj.findByCategoryAndSubCategoryNo(categoryNo, subCategoryNo);
            if(mode == "normal" || mode == "continue" || mode == "not-answered-yet"){

                var categoryPreNext = await categoryObj.checkByCategoryPreiew(categoryNo, subCategoryNo, false, mode);

                localStorage.setItem('nextcategory', JSON.stringify(categoryPreNext.nextcategory));
                localStorage.setItem('prevcategory', JSON.stringify(categoryPreNext.prevcategory));

                if(typeof categoryPreNext != 'undefined'){
                    var nextcategory = categoryPreNext.nextcategory;
                    if(typeof nextcategory == 'undefined'){
                        nextcategory = categories[0];
                        nextcategory.subCategory = categories[0]['subCategories'][0];
                        nextcategory.isSubCategory = true;
                    }

                    var prevcategory = categoryPreNext.prevcategory;
                    if(typeof prevcategory == 'undefined'){
                        prevcategory.isSubCategory = false;
                    } else {
                        prevcategory.isSubCategory = true;
                    }
                }
            }
        }

        var output;
        var templateParams = {
            nextcategory: nextcategory,
            prevcategory: prevcategory,
            fontValue: fontValue,
            category: category,
            config: config,
            isLogin: loginObj.isLogged()
        };

        if (mode != 'bookmark'){
            jsCookie.remove('quizmode');
        }

        // check is numbert quiz-no
        switch (mode) {
            case 'red-sheet':
                quiz  = await quizObj.findByRedSheetMode(categoryNo, subCategoryNo);
                break;

            case 'normal':
                quiz = await quizObj.findByNormalMode(categoryNo, subCategoryNo, quizNo, false);
                break;

            case 'incorrect':
                quiz = await quizObj.findByIncorrectMode(categoryNo, subCategoryNo);
                break;

            case 'not-answered-yet':
                quiz = await quizObj.findByNotAnsweredYetMode(categoryNo, subCategoryNo);
                break;

            case 'bookmark':
                var quizmode = jsCookie.get('quizmode');

                if (typeof(quizmode) != "undefined"){
                    quiz = await quizObj.findBySheetBookMode(categoryNo, subCategoryNo);
                } else{
                    quiz = await quizObj.findByBookmarkMode(categoryNo, subCategoryNo);
                }

                if (isNaN(subCategoryNo) && typeof quiz != "undefined"){
                    subCategoryNo = quiz.subcategory_no;
                }

                break;

            case 'random':
                quiz = await quizObj.findByRandomMode(categoryNo, subCategoryNo);
                // quiz = await quizObj.findByRandomRangeMode(categoryNo, subCategoryNo, 8);
                break;

            case 'continue':
                jsCookie.set('quiz_mode', "normal", { expires: config.LIMIT_EXPIRES_CACHE });
                quiz  = await quizObj.findByContinueMode(categoryNo, subCategoryNo);
                mode = quiz.mode;
                break;

            case 'search':
                quiz = await quizObj.findByNormalMode(categoryNo, subCategoryNo, quizNo, false, mode);
                break;

            default:
                break;
        }

	console.log("0:quizType:"+quizType);

        //set mode quiz
        if (typeof (quiz) != 'undefined') {
            quiz.mode = mode;
        } else {
            return;
        }

          // set cookie use active category on page cate list
        let info_use_set_active = JSON.stringify(
            {   
                category_no : categoryNo,
                sub_category_no : subCategoryNo
            });

        jsCookie.set('info_use_set_active', info_use_set_active, { expires: config.LIMIT_EXPIRES_CACHE });
        

        jsCookie.set('quiz_mode', mode, { expires: config.LIMIT_EXPIRES_CACHE });
        quiz.sentence = quiz.sentence.replace('&lt;MULTI_ANSWER_TAG&gt;', '').replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images').split('()').join('(<span class="show_answer_fill_blank"> 　　　 </span>)');

        /*
        * update continue quiz
        *
        * @author ChienNguyen
         */
        await continueQuiz.update(categoryNo, quiz.subcategory_no, quiz.quiz_no);

        if (mode == "red-sheet" || mode == 'bookmark'){
            jsCookie.set('sheet_page_no', quiz.pagingQuiz.currentPage, { expires: config.LIMIT_EXPIRES_CACHE });
        }

        localStorage.setItem('quiz_question', JSON.stringify(quiz));

        var quizType = quiz.quiz_type;
        templateParams.quiz = quiz;

	console.log("1:quizType:"+quizType);

        // if (mode != 'red-sheet') {
            switch (quizType) {
                case config.QUIZ_TYPE_YES_NO:
                    output = quizQuestionYesNoTemplate(templateParams);
                    break;
                case config.QUIZ_TYPE_ONE_CHOICE:
                case config.QUIZ_TYPE_MULTI_CHOICES:
                    output = quizQuestionChoicesTemplate(templateParams);
                    break;
                case config.QUIZ_TYPE_FILL_EMPTY:
                    output = quizQuestionFullBlankTemplate(templateParams);
                    break;
                case config.QUIZ_TYPE_DESCRIPTION:
                    output = quizQuestionDescriptionTemplate(templateParams);
                    break;
            }

            var pageNo = quiz.pagingQuiz.currentPage;
            if (typeof pageNo == 'undefined') {
                pageNo = 1;
            }

        if (mode == "not-answered-yet") {
            quizObj.getNotAnsweredYetMode(categoryNo);
        }

             // inner html
            innerHtmlCommon(output, config.PART_CONTENT_HTML.CONTENT_BODY);

            (function() {
                var userNumberChoices = 0;
                var userChoices = [];

                $('.answer').click(function(event) {
                    event.preventDefault();

                    var $this         = $(this);
                    var categoryNo    = $this.data('category-no');
                    var subCategoryNo = $this.data('sub-category-no');
                    var quizNo        = $this.data('quiz-no');
                    var choiceNo      = $this.data('choice-no');

                    var quizType       = quizObj.getQuizType(quiz);
                    var correctChoices = quizObj.getQuizCorrectChoices(quiz);

                    $this.toggleClass('choose');

                    if ($this.hasClass('choose')) {
                        userChoices = R.append(choiceNo, userChoices);
                    } else {
                        userChoices = R.reject(R.equals(choiceNo), userChoices);
                    }

                    var randomTotalCorrect = jsCookie.get('randomTotalCorrect');
                    var randomTotalError = jsCookie.get('randomTotalError') ;

                    switch (quizType) {
                        case config.QUIZ_TYPE_YES_NO:
                        case config.QUIZ_TYPE_ONE_CHOICE:

                            // Play sound
                            if(soundon === 'true'){
                                if (parseInt(quiz.answer_no) == parseInt(choiceNo)) {
                                    var audioplay = document.getElementById('audio_ok');
                                    audioplay.play();
                                }else {
                                    var audioplay = document.getElementById('audio_ng');
                                    audioplay.play();
                                }
                            }

                            var startTimer = $('.count-down > #time').text();
                            jsCookie.set('startTimer', startTimer, { expires: config.LIMIT_EXPIRES_CACHE });
                            if ( quiz.mode == 'red-sheet'){
                                if (parseInt(quiz.answer_no) == parseInt(choiceNo)) {
                                    randomTotalCorrect = parseInt(randomTotalCorrect) + config.LIMIT_EXPIRES_CACHE;
                                } else {
                                    randomTotalError = parseInt(randomTotalError) + config.LIMIT_EXPIRES_CACHE;
                                }
                                jsCookie.set('randomTotalCorrect', randomTotalCorrect);
                                jsCookie.set('randomTotalError', randomTotalError);
                            }

                            if(soundon === 'true'){
                                setTimeout(function () {
                                    return page.redirect(config.subfolder + '/quizz/answer/page/' + [pageNo, quiz.mode, categoryNo, subCategoryNo, quizNo, choiceNo].join('/'));
                                }, 800);
                            } else {
                                return page.redirect(config.subfolder + '/quizz/answer/page/' + [pageNo, quiz.mode, categoryNo, subCategoryNo, quizNo, choiceNo].join('/'));
                            }

                            break;
                        case config.QUIZ_TYPE_MULTI_CHOICES:
                            var answerNo = quiz.answer_no;
                            var answerNo = $.map( answerNo.split('|'), Number );
                            var difference = $(userChoices).not(answerNo).get();
                            
                            if (userChoices.length == correctChoices.length) {
                                // Play sound
                                if(soundon === 'true'){
                                    if (parseInt(quiz.answer_no) == parseInt(choiceNo)) {
                                        var audioplay = document.getElementById('audio_ok');
                                        audioplay.play();
                                    }else {
                                        var audioplay = document.getElementById('audio_ng');
                                        audioplay.play();
                                    }
                                }

                                if (quiz.mode == 'red-sheet'){
                                    if (difference.length == 0) {
                                        randomTotalCorrect = parseInt(randomTotalCorrect) + 1;
                                    } else {
                                        randomTotalError = parseInt(randomTotalError) + 1;
                                    }
                                    jsCookie.set('randomTotalCorrect', randomTotalCorrect);
                                    jsCookie.set('randomTotalError', randomTotalError);
                                }

                                var startTimer = $('.count-down > #time').text();

                                jsCookie.set('startTimer', startTimer, { expires: config.LIMIT_EXPIRES_CACHE });

                                choiceNo = userChoices.join('-');
                                if(soundon === 'true'){
                                    setTimeout(function () {
                                        return page.redirect(config.subfolder + '/quizz/answer/page/' + [pageNo, quiz.mode, categoryNo, subCategoryNo, quizNo, choiceNo].join('/'));
                                    }, 800);
                                } else {
                                    return page.redirect(config.subfolder + '/quizz/answer/page/' + [pageNo, quiz.mode, categoryNo, subCategoryNo, quizNo, choiceNo].join('/'));
                                }

                                break;
                            }
                            break;
                        case config.QUIZ_TYPE_FILL_EMPTY:
                            break;
                        case config.QUIZ_TYPE_DESCRIPTION:
                            break;
                    }
                });
            })();

        //
	console.log("2:quizType:"+quizType);

        if(quizType == config.QUIZ_TYPE_FILL_EMPTY)
        {
            (function() {
                customContentQuiz(quiz); 
                $('#buttonFillBlank').click(function(event) {
                    let userChoices = checkBeforeSubmitAnswer();
                    var choiceNo = userChoices.join('-');
                    var answerNo = quiz.answer_no;
                    var answerNo = $.map( answerNo.split('|'), String );
                    var difference = $(userChoices).not(answerNo).get();


                    if(soundon === 'true'){
                        if (difference.length == 0) {
                            var audioplay = document.getElementById('audio_ok');
                            audioplay.play();
                        }else {
                            var audioplay = document.getElementById('audio_ng');
                            audioplay.play();
                        }
                    }
                    if(soundon === 'true') {
                        setTimeout(function () {
                            // return page.redirect(config.subfolder + '/quizz/answer/page/' + [pageNo, categoryNo, subCategoryNo, quizNo, choiceNo].join('/'));
                            return page.redirect(config.subfolder + '/quizz/answer/page/' + [pageNo, quiz.mode, categoryNo, subCategoryNo, quizNo, choiceNo].join('/'));
                        }, 800);
                    } else {
                        return page.redirect(config.subfolder + '/quizz/answer/page/' + [pageNo, quiz.mode, categoryNo, subCategoryNo, quizNo, choiceNo].join('/'));
                    }
                });
            })();
        }

        if(quizType == config.QUIZ_TYPE_DESCRIPTION)
        {
            (function() {
                customContentQuiz2(quiz); 
                $('#buttonDescBlank').click(function(event) {
                    let userChoices = checkBeforeSubmitAnswer2();
                    var choiceNo = userChoices.join('-');
                    var answerNo = quiz.answer_no;
                    var answerNo = $.map( answerNo.split('|'), String );
                    var difference = $(userChoices).not(answerNo).get();


                    if(soundon === 'true'){
                        if (difference.length == 0) {
                            var audioplay = document.getElementById('audio_ok');
                            audioplay.play();
                        }else {
                            var audioplay = document.getElementById('audio_ng');
                            audioplay.play();
                        }
                    }
                    if(soundon === 'true') {
                        setTimeout(function () {
                            // return page.redirect(config.subfolder + '/quizz/answer/page/' + [pageNo, categoryNo, subCategoryNo, quizNo, choiceNo].join('/'));
                            return page.redirect(config.subfolder + '/quizz/answer/page/' + [pageNo, quiz.mode, categoryNo, subCategoryNo, quizNo, choiceNo].join('/'));
                        }, 800);
                    } else {
                        return page.redirect(config.subfolder + '/quizz/answer/page/' + [pageNo, quiz.mode, categoryNo, subCategoryNo, quizNo, choiceNo].join('/'));
                    }
                });
            })();
        }

        // }
        $('.nextcat-cancel').click(function (e) {
            $('[data-popup="popup-nextcat"]').fadeOut(350);
            e.preventDefault();
        });
        
        $('.nextCat').click(function(){
            if(mode == 'incorrect')
            {
                alert("誤答問題がなくなりました。OK");
                page.redirect(config.subfolder + '/incorrect/list-type');
            }else
            {
                $('[data-popup="popup-nextcat"]').css("display", "block");
            }
           
        });

		$('.star p').click(function(){
			if($(this).hasClass('unclick')){
		        $(this).removeClass('unclick').addClass('clicked');
		    }else{
		        $(this).removeClass('clicked').addClass('unclick');
            }

            var quizRecorderObj = new QuizRecorder();
            quizRecorderObj.bookmark(quiz);
        });

        var toggleBtn = document.querySelector('.bot_bar .font-size button');
        toggleBtn.addEventListener('click', function (e) {
            var container = e.target.previousElementSibling;
            if (container.style.cssText.match(/display[\s:]{1,3}none/)) {
                container.style.cssText = '';
            } else {
                container.style.cssText = 'display: none;';
            }
            }, false
        );

        var slider = document.getElementById("fontSize");
        slider.oninput = function() {
            fontValue = slider.value;
            document.getElementById("sec1").style.fontSize = fontValue+"px";
            jsCookie.set('fontsize', fontValue, { expires: config.LIMIT_EXPIRES_CACHE });
        };
        $('#fontSize').val(jsCookie.get('fontsize'));


        $('.right a').click(function () {
            jsCookie.set('animate', "right", { expires: config.LIMIT_EXPIRES_CACHE });
        });
        $('.left a').click(function () {
            jsCookie.set('animate', "left", { expires: config.LIMIT_EXPIRES_CACHE });
        });

        var animate = jsCookie.get('animate');
        var isbrowser = isBrowser();
        if (isbrowser != 'IE') {
            if (animate == 'right'){
                $("#sec1").css("display", "none");
                $('#sec1').toggle('slide', { direction: 'right' }, 300);

            } else if (animate == 'left') {
                $("#sec1").css("display", "none");
                $("#sec1").toggle("slide", { direction: 'left' }, 300);
                // $("#sec1").addClass(' animated faster fadeInLeft');
            } else {
                $("#sec1").toggle().fadeIn(1000);
            }
        }

        var fiveMinutes = $('.count-down #time').data('id');
        if (fiveMinutes != null && fiveMinutes != '' && fiveMinutes.length != 0){
            var display = document.querySelector('#time');
            quizObj.startTimer(parseInt(fiveMinutes), display);
        }
        $('.progress-cancle, .popup-close').click(function (e) {
            $('[data-popup="popup-random"]').fadeOut(350);
            $('[data-popup="popup-sheet"]').fadeOut(350);

            e.preventDefault();
        });

        $('#progress-next-category').click(function (e) {
            e.preventDefault();

            var href = $(this).data('href');
            page.redirect(href);
        });

        $('a').click(function (e) {
            if ($(this).parent().hasClass('back')) {
                setTimeout(function (e) {
                    funSound();
                },50)
            }
        });

        $('.back > a').click(function (e) {
            var keyworksearch = jsCookie.get('searchkeywork');
            var statussearch = jsCookie.get('list_search');

            if (typeof keyworksearch != "undefined" && statussearch == "ON") {
                page.redirect(config.subfolder + '/search');
                return false;
            } else {
                return true;
            }
        });

        // add list handle common by ChienNguyen
        commonFunct(config.DEFINE_PAGE_NAME.QUIZ);
    });

    page(config.subfolder + '/quiz/page/:pageNo/:mode/:categoryNo/:subCategoryNo?/:quizNo?', async (ctx) => {
        // add list handle common header by ChienNguyen
        commonHeaderFunct(config.DEFINE_PAGE_NAME.QUIZ);
        var soundon = localStorage.getItem("soundon");

        // client_Js.checkInfoDeviceLogin();
        var mode          = ctx.params.mode.toLowerCase();
        var categoryNo    = parseInt(ctx.params.categoryNo);
        var subCategoryNo = parseInt(ctx.params.subCategoryNo);
        var pageNo        = parseInt(ctx.params.pageNo);
        var quizNo        = parseInt(ctx.params.quizNo);
        jsCookie.remove('startTimer');

        // 
        // set cookie mode
        jsCookie.set('quiz_mode', mode, { expires: config.LIMIT_EXPIRES_CACHE });

        var quizObj         = new Quiz();
        var categoryObj     = new Category();
        var continueQuiz    = new Continue();
        var randomQuiz      = new Random();
        var loginObj        = new Login();
        var quiz;
        var category;
        var nextcategory, prevcategory;

        if (parseInt(subCategoryNo) != 0) {
            category = await categoryObj.findByCategoryAndSubCategoryNo(categoryNo, subCategoryNo);
            if(mode == "normal" || mode == "not-answered-yet"){
                var categoryPreNext = await categoryObj.checkByCategoryPreiew(categoryNo, subCategoryNo, pageNo, mode);

	console.log("000:");

                localStorage.setItem('nextcategory', JSON.stringify(categoryPreNext.nextcategory));
                localStorage.setItem('prevcategory', JSON.stringify(categoryPreNext.prevcategory));

                if(typeof categoryPreNext != 'undefined'){
                    var nextcategory = categoryPreNext.nextcategory;
                    if(typeof nextcategory == 'undefined'){
                        nextcategory = categories[0];
                        nextcategory.subCategory = categories[0]['subCategories'][0];
                        nextcategory.isSubCategory = true;
                    }

                    var prevcategory = categoryPreNext.prevcategory;
                    if(typeof prevcategory == 'undefined'){
                        prevcategory.isSubCategory = false;
                    } else {
                        prevcategory.isSubCategory = true;
                    }
                }
            }
        }

	console.log("001:");

        // check is url back
        let is_url_back = null;
        if(typeof (jsCookie.get('is_url_back')) != 'undefined')
        {
            is_url_back = jsCookie.get('is_url_back');
        }

        // set cookie use active category on page cate list
        let info_use_set_active = JSON.stringify(
            {   
                category_no : categoryNo,
                sub_category_no : subCategoryNo
            });

        jsCookie.set('info_use_set_active', info_use_set_active, { expires: config.LIMIT_EXPIRES_CACHE });


	console.log("002:");

        var output;
        var templateParams = {
            nextcategory: nextcategory,
            prevcategory: prevcategory,
            fontValue: fontValue,
            category: category,
            config: config,
            is_url_back : is_url_back,
            isLogin: loginObj.isLogged()
        };

        if (mode != 'bookmark'){
            jsCookie.remove('quizmode');
        }

	console.log("003:");

        // check is numbert quiz-no
        switch (mode) {
            case 'red-sheet':
                quiz  = await quizObj.findByRedSheetMode(categoryNo, subCategoryNo, pageNo);
                break;

            case 'normal':
                quiz = await quizObj.findByNormalMode(categoryNo, subCategoryNo, false ,pageNo);
                break;

            case 'incorrect':
                quiz = await quizObj.findByIncorrectMode(categoryNo, subCategoryNo, pageNo);
                break;

            case 'not-answered-yet':
                quiz = await quizObj.findByNotAnsweredYetMode(categoryNo, subCategoryNo, pageNo);
                break;

            case 'bookmark':
                var quizmode = jsCookie.get('quizmode');

                if (typeof(quizmode) != "undefined"){
                    quiz = await quizObj.findBySheetBookMode(categoryNo, subCategoryNo, pageNo)
                } else{
                    quiz = await quizObj.findByBookmarkMode(categoryNo, subCategoryNo, pageNo);
                }
                break;

            case 'random':
                quiz = await quizObj.findByRandomMode(categoryNo, subCategoryNo, pageNo);

                break;

            case 'continue':
                quiz  = await quizObj.findByContinueMode(categoryNo, subCategoryNo, pageNo);
                break;

            case 'incorrect_top':
                quiz = await quizObj.findByIncorrectTopMode(categoryNo, subCategoryNo, quizNo);
                break;

            case 'incorrect_random':
                quiz = await quizObj.findByIncorrectRandomMode(categoryNo, subCategoryNo, pageNo);
                break;

            case 'search':
                quiz = await quizObj.findByNormalMode(categoryNo, subCategoryNo, 0, pageNo, mode);
                break;

            default:
                break;
        }

	console.log("004:");

        // fix if not isset quiz incorrect
        if(mode == 'incorrect_random' && (typeof (quiz) == 'undefined' || quiz == null))
        {
            alert("不正解の問題はありません。");
            page.redirect(config.subfolder + '/incorrect/list-type');
        }

        if(mode == 'incorrect' && (typeof (quiz) == 'undefined' || quiz == null))
        {
            alert("誤答問題がなくなりました。");
            page.redirect(config.subfolder + '/incorrect/list-type');
        }

        // set history url before go mode
        jsCookie.set('last_access_history_url', window.location.href, { expires: config.LIMIT_EXPIRES_CACHE });

	console.log("005:");

        // set cookie mode
        jsCookie.set('quiz_mode', mode, { expires: config.LIMIT_EXPIRES_CACHE });
        // set quiz mode group
        var groupModeIncorrect = ["incorrect", "incorrect_top", "incorrect_random"];
        if(groupModeIncorrect.indexOf(mode) != -1) {
           jsCookie.set('quiz_mode_group', 'incorrect', { expires: config.LIMIT_EXPIRES_CACHE }); 
        } else {
            jsCookie.set('quiz_mode_group', null, { expires: config.LIMIT_EXPIRES_CACHE });
        }

        if (mode == "red-sheet" || mode == "bookmark"){
            jsCookie.set('sheet_page_no', quiz.pagingQuiz.currentPage, { expires: config.LIMIT_EXPIRES_CACHE });
        }
        //set mode quiz
        if (typeof (quiz) != 'undefined' && quiz != null) {
            quiz.mode = mode;
        } else {
            return;
        }
        quiz.quiz_mode_group = jsCookie.get('quiz_mode_group');

        quiz.sentence = quiz.sentence.replace('&lt;MULTI_ANSWER_TAG&gt;', '').replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images').split('()').join('(<span class="show_answer_fill_blank"> 　　　 </span>)');

	console.log("006:");

        /*
        * update continue quiz
        * @author ChienNguyen
         */
        await continueQuiz.update(categoryNo, quiz.subcategory_no, quiz.quiz_no);


	console.log("007:");

        // if (mode != 'red-sheet') {
        var quizType = quiz.quiz_type;
        templateParams.quiz = quiz;
        localStorage.setItem('quiz_question', JSON.stringify(quiz));
        switch (quizType) {
            case config.QUIZ_TYPE_YES_NO:
                output = quizQuestionYesNoTemplate(templateParams);
                break;
            case config.QUIZ_TYPE_ONE_CHOICE:
            case config.QUIZ_TYPE_MULTI_CHOICES:
                output = quizQuestionChoicesTemplate(templateParams);
                break;
            case config.QUIZ_TYPE_FILL_EMPTY:
                output = quizQuestionFullBlankTemplate(templateParams);
                break;
            case config.QUIZ_TYPE_DESCRIPTION:
                output = quizQuestionDescriptionTemplate(templateParams);
                break;
        }


	console.log("008:");

        // inner html
        innerHtmlCommon(output, config.PART_CONTENT_HTML.CONTENT_BODY);

        (function() {
            var userNumberChoices = 0;
            var userChoices = [];

            $('.answer').click(function(event) {
                event.preventDefault();
                $(this).removeClass('choose-ss')

                var $this         = $(this);
                var categoryNo    = $this.data('category-no');
                var subCategoryNo = $this.data('sub-category-no');
                var quizNo        = $this.data('quiz-no');
                var choiceNo      = $this.data('choice-no');

                var quizType       = quizObj.getQuizType(quiz);
                var correctChoices = quizObj.getQuizCorrectChoices(quiz);

                $this.toggleClass('choose');

                if ($this.hasClass('choose')) {
                    userChoices = R.append(choiceNo, userChoices);
                } else {
                    userChoices = R.reject(R.equals(choiceNo), userChoices);
                }

                var randomNote = jsCookie.get('randomNote');
                var randomTotalCorrect = jsCookie.get('randomTotalCorrect');
                var randomTotalError = jsCookie.get('randomTotalError') ;
                var quizAnswerIncorrect = [];

                switch (quizType) {
                    case config.QUIZ_TYPE_YES_NO:
                    case config.QUIZ_TYPE_ONE_CHOICE:
                        var startTimer = $('.count-down > #time').text();
                        jsCookie.set('startTimer', startTimer, { expires: config.LIMIT_EXPIRES_CACHE });

                        // Play sound
                        if(soundon === 'true'){
                            if (parseInt(quiz.answer_no) == parseInt(choiceNo)) {
                                var audioplay = document.getElementById('audio_ok');
                                audioplay.play();
                            }else {
                                var audioplay = document.getElementById('audio_ng');
                                audioplay.play();
                            }
                        }

                        $('.answer.choose-ss').addClass('disabledbutton');
                        if (quiz.mode == 'random' || quiz.mode == 'red-sheet'){
                            if (parseInt(quiz.answer_no) == parseInt(choiceNo)) {
                                randomTotalCorrect = parseInt(randomTotalCorrect) + 1;
                            } else {
                                randomTotalError = parseInt(randomTotalError) + 1;
                            }
                            jsCookie.set('randomTotalCorrect', randomTotalCorrect);
                            jsCookie.set('randomTotalError', randomTotalError);

                            if (randomNote == 'on' || quiz.mode == 'red-sheet') {

                                if(soundon === 'true'){
                                    setTimeout(function () {
                                        return page.redirect(config.subfolder + '/quizz/answer/page/' + [pageNo, quiz.mode,categoryNo, subCategoryNo, quizNo, choiceNo].join('/'));
                                    }, 800);
                                } else {
                                    return page.redirect(config.subfolder + '/quizz/answer/page/' + [pageNo, quiz.mode,categoryNo, subCategoryNo, quizNo, choiceNo].join('/'));
                                }

                                break;
                            } else {
                                if (parseInt(quiz.answer_no) == parseInt(choiceNo)) {
                                    $('.random-answer-correct').css('display', 'block');
                                    $('.random-answer-error').css('display', 'none')
                                } else {
                                    $('.random-answer-error').css('display', 'block');
                                    $('.random-answer-correct').css('display', 'none')
                                }
                            }
                        } else {
                            if(soundon === 'true'){
                                setTimeout(function () {
                                    return page.redirect(config.subfolder + '/quizz/answer/page/' + [pageNo, quiz.mode, categoryNo, subCategoryNo, quizNo, choiceNo].join('/'));
                                }, 800);
                            } else {
                                return page.redirect(config.subfolder + '/quizz/answer/page/' + [pageNo, quiz.mode, categoryNo, subCategoryNo, quizNo, choiceNo].join('/'));
                            }

                            break
                        }

                        break;
                    case config.QUIZ_TYPE_MULTI_CHOICES:
                        var answerNo = quiz.answer_no;
                        var answerNo = $.map( answerNo.split('|'), Number );
                        var difference = $(userChoices).not(answerNo).get();


                        if (userChoices.length == correctChoices.length) {
                            // Play sound
                            if(soundon === 'true'){
                                if (difference.length == 0) {
                                    var audioplay = document.getElementById('audio_ok');
                                    audioplay.play();
                                }else {
                                    var audioplay = document.getElementById('audio_ng');
                                    audioplay.play();
                                }
                            }

                            var startTimer = $('.count-down > #time').text();
                            jsCookie.set('startTimer', startTimer, { expires: config.LIMIT_EXPIRES_CACHE });

                            $('.answer.choose-ss').addClass('disabledbutton');
                            if (quiz.mode == 'random' || quiz.mode == 'red-sheet'){
                                if (difference.length == 0) {
                                    randomTotalCorrect = parseInt(randomTotalCorrect) + 1;
                                } else {
                                    randomTotalError = parseInt(randomTotalError) + 1;
                                }
                                jsCookie.set('randomTotalCorrect', randomTotalCorrect);
                                jsCookie.set('randomTotalError', randomTotalError);

                                if (randomNote == 'on' || quiz.mode == 'red-sheet') {
                                    choiceNo = userChoices.join('-');
                                    if(soundon === 'true'){
                                        setTimeout(function () {
                                            return page.redirect(config.subfolder + '/quizz/answer/page/' + [pageNo, quiz.mode, categoryNo, subCategoryNo, quizNo, choiceNo].join('/'));
                                        }, 800);
                                    } else {
                                        return page.redirect(config.subfolder + '/quizz/answer/page/' + [pageNo, quiz.mode, categoryNo, subCategoryNo, quizNo, choiceNo].join('/'));
                                    }

                                    break;
                                } else {
                                    if (difference.length == 0) {
                                        $('.random-answer-correct').css('display', 'block');
                                        $('.random-answer-error').css('display', 'none')
                                    } else {
                                        $('.random-answer-error').css('display', 'block');
                                        $('.random-answer-correct').css('display', 'none');
                                    }
                                }
                            } else {
                                choiceNo = userChoices.join('-');
                                if(soundon === 'true') {
                                    setTimeout(function () {
                                        // return page.redirect(config.subfolder + '/quizz/answer/page/' + [pageNo, categoryNo, subCategoryNo, quizNo, choiceNo].join('/'));
                                        return page.redirect(config.subfolder + '/quizz/answer/page/' + [pageNo, quiz.mode, categoryNo, subCategoryNo, quizNo, choiceNo].join('/'));
                                    }, 800);
                                } else {
                                    // return page.redirect(config.subfolder + '/quizz/answer/page/' + [pageNo, categoryNo, subCategoryNo, quizNo, choiceNo].join('/'));
                                    return page.redirect(config.subfolder + '/quizz/answer/page/' + [pageNo, quiz.mode, categoryNo, subCategoryNo, quizNo, choiceNo].join('/'));
                                }

                                break;
                            }
                        }
                        break;
                    case config.QUIZ_TYPE_FILL_EMPTY:

                        break;
                    case config.QUIZ_TYPE_DESCRIPTION:

                        break;
                }
            });
        })();

	console.log("009:");

	console.log("quizType:"+quizType);
        //
        if(quizType == config.QUIZ_TYPE_FILL_EMPTY)
        {
            (function() {
	console.log("009-01:");
                customContentQuiz(quiz); 
	console.log("009-02:");
                $('#buttonFillBlank').click(function(event) {
	console.log("009-03:");
                    let userChoices = checkBeforeSubmitAnswer();
	console.log("009-04:");
                    var choiceNo = userChoices.join('-');
	console.log("009-05:");
                    var answerNo = quiz.answer_no;
	console.log("009-06:");
                    var answerNo = $.map( answerNo.split('|'), String );
	console.log("choiceNo:"+choiceNo);
	console.log("answerNo:"+answerNo);

		    //20221202
                    //var difference = $(userChoices).not(answerNo).get();
		    var difference = [];
		    var endi = userChoices.length;
		    for ( let i = 0; i < endi; i++ ){
			if( userChoices[i] != answerNo[i] ){
				difference.push(userChoices[i]);
				console.log("difference = "+difference);
			}
			console.log("i = "+i);
		    }
		    console.log("userChoices = "+userChoices);
		    console.log("answerNo = "+answerNo);
		    console.log("difference = "+difference);

                    if(soundon === 'true'){
                        if (difference.length == 0) {
                            var audioplay = document.getElementById('audio_ok');
                            audioplay.play();
                        }else {
                            var audioplay = document.getElementById('audio_ng');
                            audioplay.play();
                        }
                    }
                    if(soundon === 'true') {
                        setTimeout(function () {
                            // return page.redirect(config.subfolder + '/quizz/answer/page/' + [pageNo, categoryNo, subCategoryNo, quizNo, choiceNo].join('/'));
                            return page.redirect(config.subfolder + '/quizz/answer/page/' + [pageNo, quiz.mode, categoryNo, subCategoryNo, quizNo, choiceNo].join('/'));
                        }, 800);
                    } else {
                        return page.redirect(config.subfolder + '/quizz/answer/page/' + [pageNo, quiz.mode, categoryNo, subCategoryNo, quizNo, choiceNo].join('/'));
                    }
                });
            })();
        }

        if(quizType == config.QUIZ_TYPE_DESCRIPTION)
        {
            (function() {
                customContentQuiz2(quiz); 

		//判定ボタン処理
                $('#buttonDescBlank').click(function(event) {
                    //let userChoices = checkBeforeSubmitAnswer2();
                    //var choiceNo = userChoices.join('-');
                    var choiceNo = "";
        	    $('.desc_blank').each(function() {
			console.log("this.value:"+this.value);
       	                if(this.value == null || this.value == "")
       	                {
				console.log("this.value1:"+this.value);
       	                        is_check_enable_button_answer = false;
       	                }
			console.log("this.value2:"+this.value);

		        console.log("choiceNo:"+choiceNo);
			if(choiceNo == "")
			{
				choiceNo = this.value;
			} else
			{
				choiceNo = choiceNo + "|" + this.value;
			}
       	            });
		    console.log("choiceNo:"+choiceNo);

                    var answerNo = quiz.answer_no;
                    var answerNo = $.map( answerNo.split('|'), String );
	console.log("choiceNo:"+choiceNo);
	console.log("answerNo:"+answerNo);

		    //20221202
                    //var difference = $(userChoices).not(answerNo).get();
/*
		    var difference = [];
		    var endi = userChoices.length;
		    for ( let i = 0; i < endi; i++ ){
			if( userChoices[i] != answerNo[i] ){
				difference.push(userChoices[i]);
				console.log("difference = "+difference);
			}
			console.log("i = "+i);
		    }
		    console.log("userChoices = "+userChoices);
		    console.log("answerNo = "+answerNo);
		    console.log("difference = "+difference);
*/

                    if(soundon === 'true'){
                        if (difference.length == 0) {
                            var audioplay = document.getElementById('audio_ok');
                            audioplay.play();
                        }else {
                            var audioplay = document.getElementById('audio_ng');
                            audioplay.play();
                        }
                    }
                    if(soundon === 'true') {
                        setTimeout(function () {
                            // return page.redirect(config.subfolder + '/quizz/answer/page/' + [pageNo, categoryNo, subCategoryNo, quizNo, choiceNo].join('/'));
                            return page.redirect(config.subfolder + '/quizz/answer/page/' + [pageNo, quiz.mode, categoryNo, subCategoryNo, quizNo, choiceNo].join('/'));
                        }, 800);
                    } else {
                        return page.redirect(config.subfolder + '/quizz/answer/page/' + [pageNo, quiz.mode, categoryNo, subCategoryNo, quizNo, choiceNo].join('/'));
                    }
                });

		//記述式入力チェック処理（判定ボタン表示）
        	$('.desc_blank').on('change', function () {

			console.log("desc_blank_change:");
        	        var is_check_enable_button_answer = true;
        	        //$('[data-desc]').each(function() {
        	        $('.desc_blank').each(function() {
				console.log("this.value:"+this.value);
        	                if(this.value == null || this.value == "")
        	                {
					console.log("this.value1:"+this.value);
        	                        is_check_enable_button_answer = false;
        	                }
					console.log("this.value2:"+this.value);
        	        });

			console.log("is_check_enable_button_answer:"+is_check_enable_button_answer);
        	        if(is_check_enable_button_answer == true)
        	        {
        	                $('#divDescBlank .button_disable').attr('style', 'display:none');
        	                $('#divDescBlank .button_enable').attr('style', 'display:inline');
        	        }else
        	        {
        	                $('#divDescBlank .button_disable').attr('style', 'display:inline');
        	                $('#divDescBlank .button_enable').attr('style', 'display:none');
        	        }
       		});

            })();
        }

	console.log("010:");

        var toggleBtn = document.querySelector('.bot_bar .font-size button');
        toggleBtn.addEventListener('click', function (e) {
            var container = e.target.previousElementSibling;
            if (container.style.cssText.match(/display[\s:]{1,3}none/)) {
                container.style.cssText = '';
            } else {
                container.style.cssText = 'display: none;';
            }
        }, false);

        var slider = document.getElementById("fontSize");
        slider.oninput = function() {
            fontValue = slider.value;
            jsCookie.set('fontsize', fontValue, { expires: config.LIMIT_EXPIRES_CACHE });
            document.getElementById("sec1").style.fontSize = fontValue+"px";
        };

        $('#fontSize').val(jsCookie.get('fontsize'));
        // }
        $('.nextcat-cancel').click(function (e) {
            $('[data-popup="popup-nextcat"]').fadeOut(350);

            e.preventDefault();
        });

        $('.popup-random-result').click(function (e) {
            $('.ageOutputIdCorrect').text(jsCookie.get('randomTotalCorrect'));
            $('.ageOutputIdError').text(jsCookie.get('randomTotalError'));
            $('[data-popup="popup-random-result"]').fadeIn(350);

            e.preventDefault();
        });

        $('.progress-category-list').click(function (e) {
            jsCookie.remove('randomTotalCorrect');
            jsCookie.remove('randomTotalError');
            jsCookie.remove('random');

            return page.redirect(config.subfolder + config.category_list);
        });

        $('.nextCat').click(function(){
            if(mode == 'incorrect')
            {
                alert("誤答問題がなくなりました。");
                page.redirect(config.subfolder + '/incorrect/list-type');
            }else
            {
                $('[data-popup="popup-nextcat"]').css("display", "block");
            }
        });
        $('.star p').click(function(){
			if($(this).hasClass('unclick')){
		        $(this).removeClass('unclick').addClass('clicked');
		    }else{
		        $(this).removeClass('clicked').addClass('unclick');
            }
            var quizRecorderObj = new QuizRecorder();
            quizRecorderObj.bookmark(quiz);
        });

        $('.right a').click(function () {
            jsCookie.set('animate', "right", { expires: config.LIMIT_EXPIRES_CACHE });
        });
        $('.left a').click(function () {
            jsCookie.set('animate', "left", { expires: config.LIMIT_EXPIRES_CACHE });
        });

        var animate = jsCookie.get('animate');
        var isbrowser = isBrowser();
        if (isbrowser != 'IE') {
            if (animate == 'right'){
                $("#sec1").css("display", "none");
                $('#sec1').toggle('slide', { direction: 'right' }, 300);

            } else if (animate == 'left') {
                $("#sec1").css("display", "none");
                $("#sec1").toggle("slide", { direction: 'left' }, 300);
                // $("#sec1").addClass(' animated faster fadeInLeft');
            } else {
                $("#sec1").toggle().fadeIn(1000);
            }
        }

        jsCookie.remove('animate');

        var fiveMinutes = $('.count-down #time').data('id');
        if (fiveMinutes != null && fiveMinutes != '' && fiveMinutes.length != 0){
            var display = document.querySelector('#time');
            quizObj.startTimer(parseInt(fiveMinutes), display);
        }
        $('.progress-cancle, .popup-close').click(function (e) {
            $('[data-popup="popup-random"]').fadeOut(350);
            $('[data-popup="popup-sheet"]').fadeOut(350);
            e.preventDefault();
        });

        // proccess next Categories
        $('#progress-next-category').click(function (e) {
            e.preventDefault();
            var href = $(this).data('href');
            page.redirect(href);
        });

        // add list handle common by ChienNguyen
        commonFunct(config.DEFINE_PAGE_NAME.QUIZ);
        $('a').click(function (e) {
            if ($(this).parent().hasClass('back')) {
                setTimeout(function (e) {
                    funSound();
                },50)
            }
        });

        $('.back > a').click(function (e) {
            var keyworksearch = jsCookie.get('searchkeywork');
            var statussearch = jsCookie.get('list_search');

            if (typeof keyworksearch != "undefined" && statussearch == "ON") {
                page.redirect(config.subfolder + '/search');
                return false;
            } else {
                return true;
            }
        });

    });

    page(config.subfolder + '/quizz/answer/page/:pageNo/:mode/:categoryNo/:subCategoryNo/:quizNo/:userAnswers', async (ctx) => {
        var start = +new Date();  // log start timestamp

        // add list handle common header by ChienNguyen
        commonHeaderFunct(config.DEFINE_PAGE_NAME.QUIZ_ANSWER);
        var soundon = localStorage.getItem("soundon");

        var start = +new Date();  // log start timestamp

        // client_Js.checkInfoDeviceLogin();
        var categoryNo    = parseInt(ctx.params.categoryNo);
        var subCategoryNo = parseInt(ctx.params.subCategoryNo);
        var quizNo        = parseInt(ctx.params.quizNo);
        var mode          = ctx.params.mode;
        var pageNo        = parseInt(ctx.params.pageNo);

/*
        var userAnswers   = ctx.params.userAnswers
                                .split('-')
                                .map((answer) => parseInt(answer));
        var bkUserAnswers = ctx.params.userAnswers
                                .split('-')
                                .map((answer) => parseInt(answer));
*/
        var quiz = JSON.parse(localStorage.getItem('quiz_question'));
        var quizType3       = quiz.quiz_type;
        console.log("quizType3 =" +quizType3);
        if(quizType3 == config.QUIZ_TYPE_DESCRIPTION){
        	var userAnswers   = ctx.params.userAnswers
                                .split('|')
                                .map((answer) => String(answer));
        	var bkUserAnswers = ctx.params.userAnswers
                                .split('|')
                                .map((answer) => String(answer));
	} else {
        	var userAnswers   = ctx.params.userAnswers
                                .split('-')
                                .map((answer) => parseInt(answer));
        	var bkUserAnswers = ctx.params.userAnswers
                                .split('-')
                                .map((answer) => parseInt(answer));
	}
        console.log("userAnswers =" +userAnswers);

        var quizObj         = new Quiz();
        var quizRecorderObj = new QuizRecorder();
        var categoryObj     = new Category();
        let recordObj       = new QuizRecorder();
        var loginObj        = new Login();
        var randomQuiz      = new Random();

        console.log("100");
        console.log("subCategoryNo =" +subCategoryNo);

        if (parseInt(subCategoryNo) != 0) {
            var categoryPreNext = await categoryObj.checkByCategoryPreiew(categoryNo, subCategoryNo);
            // var prevcategory = JSON.parse(localStorage.getItem('prevcategory'));
            // var nextcategory = JSON.parse(localStorage.getItem('nextcategory'));
            var prevcategory = categoryPreNext.prevcategory;
            var nextcategory = categoryPreNext.nextcategory;

            // if(typeof categoryPreNext != 'undefined'){
                // var nextcategory = categoryPreNext.nextcategory;

            if(typeof nextcategory == 'undefined'){
                nextcategory = categories[0];
                nextcategory.subCategory = categories[0]['subCategories'][0];
                nextcategory.isSubCategory = true;
            }

            // var prevcategory = JSON.parse(localStorage.getItem('prevcategory'));
            // var prevcategory = categoryPreNext.prevcategory;
            if(typeof prevcategory == 'undefined'){
                prevcategory.isSubCategory = false;
            } else {
                prevcategory.isSubCategory = true;
            }
            // }

            // var quiz     = await quizObj.find(categoryNo, subCategoryNo, quizNo, pageNo, mode);
            var category = await categoryObj.findByCategoryAndSubCategoryNo(categoryNo, subCategoryNo);

        } else {
            // var quiz     = await quizObj.findAnswerQuizSubZero(categoryNo, subCategoryNo, quizNo, pageNo);
            var category = await categoryObj.findByCategoryAndSubCategoryNo(categoryNo, quiz.subcategory_no);
        }
        var quiz = JSON.parse(localStorage.getItem('quiz_question'));

        var query = +new Date();  // log start timestamp

        await quizRecorderObj.solve(quiz, userAnswers);

        console.log("101");
        
        // handle mode 
        if(jsCookie.get('quiz_mode') == 'incorrect_random')
        {
            var info_quiz =  await quizObj.findByIncorrectRandomMode(categoryNo, subCategoryNo, pageNo, true, quizNo);
            if(info_quiz)
            {
                quiz.pagingQuiz = info_quiz.pagingQuiz;
            }
            prevcategory.isSubCategory = false;
        }

        console.log("102");

        if(jsCookie.get('quiz_mode') == 'incorrect')
        {
            var info_quiz =  await quizObj.findByIncorrectMode(categoryNo, subCategoryNo, pageNo, true, quizNo);
            if(info_quiz)
            {
                quiz.pagingQuiz = info_quiz.pagingQuiz;
            }
            prevcategory.isSubCategory = false;
        }

        console.log("103");

        if (typeof quiz.mode != 'undefined'){
            quiz.mode   = jsCookie.get('quiz_mode');
        }
        quiz.quiz_mode_group   = jsCookie.get('quiz_mode_group');
        

        var quizmode = jsCookie.get('quizmode');

        console.log("104");

        if (quiz.mode == 'red-sheet') {
            var page_no = jsCookie.get('sheet_page_no');
            // var quiz = await quizObj.findByRedSheetMode(categoryNo, subCategoryNo, parseInt(page_no));
            var quiz = JSON.parse(localStorage.getItem('quiz_question'));
            quiz.comment = quiz.comment
                .replace(/<font color="red">/g, '<font color="red" style="background-color:red;" onclick="this.style.background=\'white\'">')
                .replace(/<font color="red" style="background-color:red;" onclick="this.style.background='white'">&#215;<\/font>/g, '<font color="red">&#215;</font>')
                .replace(/<font color="red" style="background-color:red;" onclick="this.style.background='white'">〇<\/font>/g, '<font color="red">〇</font>');
        } else if (typeof quizmode != "undefined") {
            var page_no = jsCookie.get('sheet_page_no');
            // var quiz = await quizObj.findBySheetBookMode(categoryNo, subCategoryNo, parseInt(page_no));
            var quiz = JSON.parse(localStorage.getItem('quiz_question'));

            quiz.comment = quiz.comment
                .replace(/<font color="red">/g, '<font color="red" style="background-color:red;" onclick="this.style.background=\'white\'">')
                .replace(/<font color="red" style="background-color:red;" onclick="this.style.background='white'">&#215;<\/font>/g, '<font color="red">&#215;</font>')
                .replace(/<font color="red" style="background-color:red;" onclick="this.style.background='white'">〇<\/font>/g, '<font color="red">〇</font>');
        }

        console.log("105");

        // set history url before go mode
        jsCookie.set('last_access_history_url', window.location.href, { expires: config.LIMIT_EXPIRES_CACHE });

        var quizAnswers = quiz.answer_no
            .split('|')
            // Array.indexOf method below is strict-type. So I convert string to number here.
            .map((answerNo) => parseInt(answerNo));
        var bkquizAnswers = quiz.answer_no
            .split('|')
            // Array.indexOf method below is strict-type. So I convert string to number here.
            .map((answerNo) => parseInt(answerNo));

        quiz.choices = quiz.choices.map((choice) => {
            choice.isCorrect = R.contains(choice.choice_no, quizAnswers);
            choice.isChosen  = R.contains(choice.choice_no, userAnswers);
            return choice;
        });
        quiz.record  = await recordObj.getQuizRecord(categoryNo, quiz.quiz_no);

        if (quizRecorderObj.isAnswerCorrect(quiz, userAnswers) && quiz.mode == 'incorrect'){
            // if (typeof quiz.pagingQuiz.pageNext !== 'undefined'){
            //     quiz.pagingQuiz.pageNext--;
            // }
        }
        if(quizRecorderObj.isAnswerCorrect(quiz, userAnswers)){
            $(document).ready(function(){
                $("h5.result").css("color", "blue");
                $("#list_style #sec2 .correct").css("color", "#fff");
            })
        }

        console.log("106");

        // 
        if(localStorage.getItem('ACCESS_QUIZ')){
            let tmpAccess = JSON.parse(localStorage.getItem('ACCESS_QUIZ'));
            let key = quiz.id + '_false';
            let tmpkey = tmpAccess.indexOf(key); 
            if(tmpkey != -1){
                tmpAccess.splice(tmpkey, 1);
                key = quiz.id + '_true';
                tmpAccess.push(key);
                localStorage.setItem('ACCESS_QUIZ', JSON.stringify(tmpAccess));
            }
        }
            

        console.log("107");

        // check is url back
        let is_url_back = null;
        if(typeof (jsCookie.get('is_url_back')) != 'undefined')
        {
            is_url_back = jsCookie.get('is_url_back');
        }
          // set cookie use active category on page cate list
        let info_use_set_active = JSON.stringify(
            {   
                category_no : categoryNo,
                sub_category_no : subCategoryNo
            });

        jsCookie.set('info_use_set_active', info_use_set_active, { expires: config.LIMIT_EXPIRES_CACHE });

	//20221202
	//var answerResult = R.equals(userAnswers.sort(), quizAnswers.sort()) ? 1 : 0 ;
	var quiz = JSON.parse(localStorage.getItem('quiz_question'));
	var quizType2       = quiz.quiz_type;
	console.log("quizType2 =" +quizType2);
	//console.log("quiz =" +quiz);
	console.log("quiz.answer_no =" +quiz.answer_no);
	console.log("userAnswers =" +userAnswers);
	console.log("quizAnswers =" +quizAnswers);
	if(quizType2 == config.QUIZ_TYPE_FILL_EMPTY){
		var answerResult = R.equals(userAnswers, quizAnswers) ? 1 : 0 ;
		var answerStatus = R.equals(userAnswers, quizAnswers) ? config.ANSWER.RIGHT : config.ANSWER.WRONG ;
	} else if(quizType2 == config.QUIZ_TYPE_DESCRIPTION) {
		//初期値1（正解）、1問でも間違いがあると0（不正解）
		var answerResult = 1;
		console.log("answerResult1 =" +answerResult);
		console.log("quiz.answer_no =" +quiz.answer_no);
		//問題数分繰り返し（記述式の場合、正解番号が問題数）
                for (var i = 0; i < quiz.answer_no; i++) {
			//選択肢の値が全て含まれるか確認
			var expand_choice = quiz.choices[i].answer.split('|');
			console.log("expand_choice.map =" +expand_choice.map);
			expand_choice.forEach(function( value ){
				console.log("i =" +i);
				console.log("userAnswers[i] =" +userAnswers[i]);
				console.log("value =" +value);
				if(userAnswers[i].indexOf(value) == -1) {
					answerResult = 0;
					console.log("answerResult0 =" +answerResult);
				}
			})
			var answerStatus = (answerResult == 1) ? config.ANSWER.RIGHT : config.ANSWER.WRONG ;
		}
	} else {
		var answerResult = R.equals(userAnswers.sort(), quizAnswers.sort()) ? 1 : 0 ;
		var answerStatus = R.equals(userAnswers.sort(), quizAnswers.sort()) ? config.ANSWER.RIGHT : config.ANSWER.WRONG ;
	}
	console.log("answerResult =" +answerResult);
	console.log("answerStatus =" +answerStatus);
        var output;
        var templateParams = {
            nextcategory: nextcategory,
            prevcategory: prevcategory,
            fontValue: fontValue,
            category:     category,
            quiz:         quiz,
            is_url_back: is_url_back,
            // answerStatus: R.equals(userAnswers.sort(), quizAnswers.sort()) ? '正解です。' : '不正解です。',
	    //20221202
            //answerStatus: R.equals(userAnswers.sort(), quizAnswers.sort()) ? config.ANSWER.RIGHT : config.ANSWER.WRONG ,
            answerStatus: answerStatus,
            answerResult: answerResult,
            config: config,
            isLogin: loginObj.isLogged()
        };


        console.log("108");

        if (!answerResult && quiz.mode == 'random') {
            var resultRandom = await randomQuiz.findUpdateRandomQuizStatus(quiz);
        }

        var quizType = quiz.quiz_type;
        var quiz_mode = jsCookie.get('quiz_mode');

        switch (quizType) {
            case config.QUIZ_TYPE_YES_NO:
                output = quizAnswerYesNoTemplate(templateParams);
                break;
            case config.QUIZ_TYPE_ONE_CHOICE:
            case config.QUIZ_TYPE_MULTI_CHOICES:
                output = quizAnswerChoicesTemplate(templateParams);
                break;
            case config.QUIZ_TYPE_FILL_EMPTY:
                output = quizAnswerChoicesTemplate(templateParams);
                break;
            case config.QUIZ_TYPE_DESCRIPTION:
                //output = quizQuestionDescriptionTemplate(templateParams);
                output = quizAnswerChoicesTemplate2(templateParams);
                break;
        }


        console.log("109");

         // inner html
        innerHtmlCommon(output, config.PART_CONTENT_HTML.CONTENT_BODY);

        if(quizType == config.QUIZ_TYPE_FILL_EMPTY)
        {
            var textChoice = {};
            if(quiz.choices.length)
            {
                quiz.choices.forEach(choices => {
                    textChoice[choices.choice_no] = choices.answer;
                });
            }
            customContentQuizForAnswer();
            let listFill = getListFillBlank();

            var expand_phrase = false;
            if(quiz && quiz.choices && quiz.choices[0].answer.indexOf('|') != -1)
            {
                expand_phrase = true;
                listFill.sort();
            }
            if(listFill.length)
            {
                for(var i =0; i < listFill.length; i++)
                {
                    if(bkUserAnswers[i])
                    {
                        var tmpText = '';
                        if(expand_phrase == true && quiz.choices[i]){
                            var expand_choice = quiz.choices[i].answer.split('|');
                            // bitone修正 20200217
                            tmpText = expand_choice[bkUserAnswers[i]-1] ? expand_choice[bkUserAnswers[i]-1] : '';
                        }else{
                            tmpText = textChoice[bkUserAnswers[i]] ? textChoice[bkUserAnswers[i]] : '';
                        }

                        if(bkquizAnswers[i] && bkUserAnswers[i] == bkquizAnswers[i])
                        {
                            $('[data-fill="'+ listFill[i] +'"] span').html(tmpText).addClass('fill_blank_select');
                        }else{
                            $('[data-fill="'+ listFill[i] +'"] span').html(tmpText).addClass('fill_blank_error');
                        }

                    }
                }
            }
        }

        $('.nav-toggle').click(function() {
            var selector = $(this).data('id');
            $(selector).toggle();
        });

        console.log("110");

        var toggleBtn = document.querySelector('.bot_bar .font-size button');
        toggleBtn.addEventListener('click', function (e) {
            var container = e.target.previousElementSibling;
            if (container.style.cssText.match(/display[\s:]{1,3}none/)) {
                container.style.cssText = '';
            } else {
                container.style.cssText = 'display: none;';
            }
        }, false);

        var slider = document.getElementById("fontSize");
        slider.oninput = function() {
            fontValue = slider.value;
            document.getElementById("sec2").style.fontSize = fontValue+"px";
        };

        console.log("111");

        $('.nextCat').click(function(){
            if(mode == 'incorrect_random')
            {
                alert("不正解の問題はありません。");
            }
            else if (mode == 'incorrect')
            {
                alert("誤答問題がなくなりました。");
                page.redirect(config.subfolder + '/incorrect/list-type');
            }else
            {
                $('[data-popup="popup-nextcat"]').css("display", "block");
            }
            
        });
        $('.nextcat-cancel').click(function (e) {
            $('[data-popup="popup-nextcat"]').fadeOut(350);
            e.preventDefault();
        });
        $('.star p').click(function(){
			if($(this).hasClass('unclick')){
		        $(this).removeClass('unclick').addClass('clicked');
		    }else{
		        $(this).removeClass('clicked').addClass('unclick');
            }

            var quizRecorderObj = new QuizRecorder();
            quizRecorderObj.bookmark(quiz);
        });

        console.log("112");

        $('.popup-random-result').click(function (e) {
            $('.ageOutputIdCorrect').text(jsCookie.get('randomTotalCorrect'))
            $('.ageOutputIdError').text(jsCookie.get('randomTotalError'))
            $('[data-popup="popup-random-result"]').fadeIn(350);
            e.preventDefault();
        });

        $('.progress-category-list').click(function (e) {
            jsCookie.remove('randomTotalCorrect');
            jsCookie.remove('randomTotalError');
            jsCookie.remove('random');
            jsCookie.set('category_random_mode', quiz.category_no + '-' + quiz.category_no, { expires: config.LIMIT_EXPIRES_CACHE });
            return page.redirect(config.subfolder + config.category_list);

        });

        console.log("113");

        $('.progress-random-again').click(function (e) {
            var result = randomQuiz.deleteRandomQuizStatusCorrect();
            result.then(function (value) {
                jsCookie.set('randomTotalCorrect', 0, { expires: config.LIMIT_EXPIRES_CACHE });
                jsCookie.set('randomTotalError', 0, { expires: config.LIMIT_EXPIRES_CACHE });
                db.open();
                db.random_quiz.bulkPut(value);
                return page.redirect(config.subfolder + '/quiz/page/1/random/' + value[0]['category_no'] + '/' + value[0]['subcategory_no'] + '/' + value[0]['quiz_no']);
            });
        });

        $('.right a').click(function () {
            jsCookie.set('animate', "right", { expires: config.LIMIT_EXPIRES_CACHE });
        });

        $('.left a').click(function () {
            jsCookie.set('animate', "left", { expires: config.LIMIT_EXPIRES_CACHE });
        });

        console.log("114");

        var animate = jsCookie.get('animate');
        if (animate == 'right'){
            $("#sec2").toggle();
        } else if (animate == 'left') {
            $("#sec2").toggle();
        } else {
            $("#sec2").toggle();
        }

        jsCookie.remove('animate');

        console.log("115");

        var fiveMinutes = $('.count-down #time').data('id');
        if (fiveMinutes != null && fiveMinutes != '' && fiveMinutes.length != 0){
            var startTimer = jsCookie.get('startTimer');
            var display = document.querySelector('#time');
            display.textContent = startTimer;
            jsCookie.remove('startTimer');
        }
        // proccess next Categories
        $('#progress-next-category').click(function (e) {
            e.preventDefault();
            var href = $(this).data('href');
            page.redirect(href);
        });

        // add list handle common by ChienNguyen
        commonFunct(config.DEFINE_PAGE_NAME.QUIZ_ANSWER);

        funcAnswerError();
        funcAnswerSeccess();

        console.log("116");

        $(document).ready( function (e) {
            $("#sec2").css("display", "none");
            $("#sec2").toggle();

            $('a').click(function (e) {
                if ($(this).parent().hasClass('back')) {
                    funSound();
                }
            });
        });

        $('.back > a').click(function (e) {
            var keyworksearch = jsCookie.get('searchkeywork');
            var statussearch = jsCookie.get('list_search');

            if (typeof keyworksearch != "undefined" && statussearch == "ON") {
                page.redirect(config.subfolder + '/search');
                return false;
            } else {
                return true;
            }
        });

        console.log("117");

        var end = +new Date();  // log start timestamp
        var diff = end - start;  // log start timestamp
        console.log("Time load: " + diff);
    });

    page(config.subfolder + config.user_detail, function() {
        // add list handle common header by ChienNguyen
        commonHeaderFunct(config.DEFINE_PAGE_NAME.USER_DETAIL);

        // client_Js.checkInfoDeviceLogin();
        var loginObj = new Login();
        jsCookie.remove('quizmode');
        jsCookie.remove('random');
        if(!loginObj.isLogged()){
            page.redirect(config.subfolder);
            return true;
        }
        var user = jsCookie.get('user');
        var jsonUser = $.parseJSON(user);
        jsonUser.subfolder = config.subfolder;
        jsonUser.change_info_user = config.DISABLE_UPDATE_INFO_USER;

        var output = userDetailTemplate(jsonUser);

         // inner html
        innerHtmlCommon(output, config.PART_CONTENT_HTML.CONTENT_BODY);

        // var loginObj = new Login();
        var objUser = new User();
        $('#logout').click(function () {
            loginObj.logout();
        });
        $('.update').click(function () {
            var parentElement = $(this).closest('dl');
            var column = parentElement.find('input').attr('name');
            var value = parentElement.find('input').val();
            var learner_id = jsCookie.get('id_logged');
            objUser.update(learner_id, column, value);
        });

        // add list handle common
        commonFunct(config.DEFINE_PAGE_NAME.USER_DETAIL);
        $(document).ready(function () {
            soundFunction();
        })
    });

    //message
    page(config.subfolder + config.user_message, async (ctx) => {
        // add list handle common header by ChienNguyen
        commonHeaderFunct(config.DEFINE_PAGE_NAME.USER_MESSAGE);

        // client_Js.checkInfoDeviceLogin();
        jsCookie.remove('quizmode');
        jsCookie.remove('random');
        var messageObj = new Message();
        var syncDatas = new SyncData();
        var learner_id = jsCookie.get('id_logged');

        syncDatas.getMessageList(learner_id, 'listMessage');

        var message = await messageObj.getMessagesList();

        var output;
        var templateParams = {
            config: config,
            message: message,
        };

        if (message != null) {
            templateParams.message.forEach(function(el,key){
                el.message = el.message.substring(0, 25).split('<')[0];
                el.sfolder = config.subfolder;
                el.stt = key+1;
            });
        }

        var output = userMessageTemplate(templateParams);

         // inner html
        innerHtmlCommon(output, config.PART_CONTENT_HTML.CONTENT_BODY);

        // add list handle common
        commonFunct(config.DEFINE_PAGE_NAME.USER_MESSAGE);

        $(document).ready(function () {
            soundFunction();
        })

    });

    page(config.subfolder + config.user_message_one + '/:id?', async (ctx) => {
        // add list handle common header by ChienNguyen
        commonHeaderFunct(config.DEFINE_PAGE_NAME.USER_MESSAGE_ONE);

        // client_Js.checkInfoDeviceLogin();
        var id    = parseInt(ctx.params.id);
        var messageObj = new Message();
        jsCookie.remove('quizmode');
        jsCookie.remove('random');
        var message = await messageObj.getMessagesOne(id);
        var output;
        var templateParams = {
            message: message,
            config: config,
        };
        var output = userMessageOneTemplate(templateParams);

         // inner html
        innerHtmlCommon(output, config.PART_CONTENT_HTML.CONTENT_BODY);

        // add list handle common
        commonFunct(config.DEFINE_PAGE_NAME.USER_MESSAGE_ONE);

        $(document).ready(function (e) {
            soundFunction();
        })
    });

    page(config.subfolder + config.user_config, function () {
        // add list handle common header by ChienNguyen
        commonHeaderFunct(config.DEFINE_PAGE_NAME.USER_CONFIG);

        var loginObj = new Login();

        if(!loginObj.isLogged()){
            page.redirect(config.subfolder);
            return true;
        }
        var user = jsCookie.get('user');
        var jsonUser = $.parseJSON(user);
        jsonUser.subfolder = config.subfolder;
        var output = userConfiguration({jsonUser, config: config});  

         // inner html
        innerHtmlCommon(output, config.PART_CONTENT_HTML.CONTENT_BODY);
        var soundon = localStorage.getItem('soundon');

        $(document).ready(function(){
            // set active button
            if(soundon === 'true'){
                $('#toggleSound').attr( 'checked', 'checked' );
            }else{
                $('#toggleSound').removeAttr('checked');
            }

            $('a').click(function () {
                var sound = localStorage.getItem('soundon');
                if(sound === 'true'){
                    setTimeout(function (e) {
                        var myAudio = document.getElementById('audio_click');
                        myAudio.play();
                    }, 50)
                }
            });
        });

        // update soundon flag
        $('#switchSound input[type="checkbox"]').click(function(){
            var currentSoundValue = localStorage.getItem("soundon");
            var soundValue = true;

            if(currentSoundValue === 'true') {
                soundValue = false;
            }
            soundon = soundValue;
            localStorage.setItem("soundon", soundValue);
            funSound();
        });

        // add list handle common
        commonFunct(config.DEFINE_PAGE_NAME.USER_CONFIG);

    });

    page(config.subfolder + config.forgot_password, function() {
        // add list handle common header by ChienNguyen
        commonHeaderFunct(config.DEFINE_PAGE_NAME.FORGOT_PASSWORD);


        // client_Js.checkInfoDeviceLogin();
        var objUser = new User();
        var output = forgotPasswordTemplate({config: config});

         // inner html
        innerHtmlCommon(output, config.PART_CONTENT_HTML.CONTENT_BODY);

        $('#forgot-pass').click(function () {
            var userEmail = $('#user-email').val();
            objUser.forgotPassword(userEmail);
        });

        $(document).keypress(function (event) {
            if (event.which == 13 || event.keyCode == 13) {
                event.preventDefault();
                $('#forgot-pass').click();

                return false;
            }
        });

        goHome();

        // add list handle common
        commonFunct(config.DEFINE_PAGE_NAME.FORGOT_PASSWORD);

        $(document).ready(function () {
            var soundon = localStorage.getItem("soundon");
            soundFunction();
        })
    });

    // My page
    page(config.subfolder + '/mypage/report', async function() {
        // add list handle common header by ChienNguyen
        commonHeaderFunct(config.DEFINE_PAGE_NAME.MYPAGE_REPORT);

        // client_Js.checkInfoDeviceLogin();
        document.getElementById("loadingOverlay").style.display = 'block';
        var myPageObj = new Mypage();

        // access first
        let reportInfo = [];
        var output = myPageReportTemplate({"reportInfo" : reportInfo, "api_url": config.api_url, config: config});

         // inner html
        innerHtmlCommon(output, config.PART_CONTENT_HTML.CONTENT_BODY);
        goHome();

        if(navigator.onLine){
            let content = await myPageObj.getStudyInfo();
            console.log("MyPage保存");
       
            $.ajax({
                type: "POST",
                url : config.url_api_mypage_report,
                data: {'content' : content},
                async: false,
                success: function(data){
                    if(data.response){
                        let reportInfo = JSON.parse(Base64.decode(data.response));
                        jsCookie.set('user_rank', reportInfo.rank.rank_no, { expires: config.LIMIT_EXPIRES_CACHE });
                        var output = myPageReportTemplate({"reportInfo" : reportInfo, "api_url": config.api_url, config: config});

                        // inner html
                        innerHtmlCommon(output, config.PART_CONTENT_HTML.CONTENT_BODY);

                        goHome();
                    }
                    document.getElementById("loadingOverlay").style.display = 'none';
                },
                error: function (xhr, status) {
                    alert(config.NETWORK.OFFLINE_MYPAGE);
                    document.getElementById("loadingOverlay").style.display = 'none';
                }
            });
        }


        document.getElementById("loadingOverlay").style.display = 'none';
        // add list handle common
        commonFunct(config.DEFINE_PAGE_NAME.MYPAGE_REPORT);

        $(document).ready(function () {
            soundFunction();
        })
    });

    page(config.subfolder + '/mypage/score', async function() {
        // add list handle common header by ChienNguyen
        commonHeaderFunct(config.DEFINE_PAGE_NAME.MYPAGE_SCORE);

        document.getElementById("loadingOverlay").style.display = 'block';

        // client_Js.checkInfoDeviceLogin();
        const myPageObj = new Mypage();
        let result = await myPageObj.getScoreInfo();
        var output = myPageScoreTemplate({'result' : result, config: config});

         // inner html
        innerHtmlCommon(output, config.PART_CONTENT_HTML.CONTENT_BODY);
        document.getElementById("loadingOverlay").style.display = 'none';

        var prefs = {
            element: ".circlebar"
        };
        $('.circlebar').each(function() {
            prefs.element = $(this);
            new Circlebar(prefs);
        });

        $(".toggle .nav-toggle").click(function(e) {
            var collapse_content_selector = $(this).data('rel');
            $('#' + collapse_content_selector).toggle(function(){
                $(this).css('display')=='none'
            });
            e.preventDefault();
        });

        progress_fnc();
        goHome();

        // add list handle common
        commonFunct(config.DEFINE_PAGE_NAME.MYPAGE_SCORE);

        $(document).ready(function () {
            soundFunction();
        })
    });

    /*
    *
    * page ranking
    * 
    * @updated 2019.01.12
    */

    page(config.subfolder + '/mypage/ranking', async function() {
        // add list handle common header by ChienNguyen
        commonHeaderFunct(config.DEFINE_PAGE_NAME.MYPAGE_RANKING);

        let learner_id = jsCookie.get('id_logged');
        if(navigator.onLine){
            $.ajax({
                type: "POST",
                url : config.url_api_get_ranks,
                headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                success: function(data){
                    if(data.response){
                        let rank_no = jsCookie.get('user_rank');
                        let learnerInfo = `{
                            "rank_no" : "${rank_no}",
                            "learner_id" : "${learner_id}"
                        }`;
                        $.ajax({
                            type: "POST",
                            url : config.url_api_get_leraner_list_by_rank,
                            data: {'content' : Base64.encode(learnerInfo)},
                            headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                            success: function(data){
                                var result = [];
                                if(data.result == "OK"){
                                    result = Base64.decode(data.response);
                                }
                                result = JSON.parse(result);
                                var output = myPageRankingTemplate({'result' : result, config: config});

                                 // inner html
                                innerHtmlCommon(output, config.PART_CONTENT_HTML.CONTENT_BODY);
                                goHome();
                                handleRanking();
                            },
                            error: function (xhr, status) {
                                alert(config.NETWORK.OFFLINE_MYPAGE);
                                var output = myPageRankingTemplate({'result' : [], config: config});

                                 // inner html
                                innerHtmlCommon(output, config.PART_CONTENT_HTML.CONTENT_BODY);
                                goHome();
                                handleRanking();
                            }
                        });
                    }
                },
                error: function (xhr, status) {
                    console.log('Call url_api_get_ranks error');
                    var output = myPageRankingTemplate({'result' : [], config: config});

                     // inner html
                    innerHtmlCommon(output, config.PART_CONTENT_HTML.CONTENT_BODY);
                    goHome();
                    handleRanking();
                }
            });
        }else
        {
            var output = myPageRankingTemplate({'result' : [], config: config});
            innerHtmlCommon(output, config.PART_CONTENT_HTML.CONTENT_BODY);
            goHome();
        }
        // add list handle common
        commonFunct(config.DEFINE_PAGE_NAME.MYPAGE_RANKING);
        $(document).ready(function () {
            $('a').click(function (e) {
                if ($(this).parent().hasClass('back')) {
                    funSound();
                }
            });
        })
    });

    /**
     * Incorrect page
     * 
     *
     * @updated 21.12.2018
     */

    page(config.subfolder + '/incorrect/list-type', async function(ctx) {
        document.getElementById("loadingOverlay").style.display = 'block';
        var output = incorrectListTypeTemplate({templateParams: [], config: config});
        innerHtmlCommon(output, config.PART_CONTENT_HTML.CONTENT_BODY);

        // add list handle common header by ChienNguyen
        commonHeaderFunct(config.DEFINE_PAGE_NAME.INCORRECT_LIST_TYPE);

        // client_Js.checkInfoDeviceLogin();
        var categoryNo    = 0;
        var incorrectObj = new Incorrect();
        var quizObj = new Quiz();

        // 
        var listTopQuizIncorrect  = await incorrectObj.getTopQuizIncorrect();

        // 
        var listQuizIncorrectSortedByCate  = await incorrectObj.getListQuizIncorrectSortedByCate(config.client_flg);

        var listQuizIncorrect  = await incorrectObj.getListQuizIncorrectSortedByCate(config.client_flg);

        let arrayQuizIncorrect = createListQuizIncorrectRandom(listQuizIncorrect);
        
        await incorrectObj.createRandomIncorrectFromArray(arrayQuizIncorrect);

        let first_page = 1;
        let firstIncorrectRandom = await incorrectObj.getInfoQuizForRandomIncorrect(first_page);

        /**
         * get list quiz incorrect for answer random
         * create random quiz
         * 
         * @return list object quiz 
         * @updated 21.12.2018
         */
        var quizRandom = null;
        if(firstIncorrectRandom)
        {
            quizRandom = firstIncorrectRandom;
        }


        //
        let templateParams = {
            'listTopQuizIncorrect'          : listTopQuizIncorrect,
            'listQuizIncorrectSortedByCate' : listQuizIncorrectSortedByCate,
            'quizRandom'                    : quizRandom
        };

        var output = incorrectListTypeTemplate({templateParams: templateParams, config: config});

         // inner html
        innerHtmlCommon(output, config.PART_CONTENT_HTML.CONTENT_BODY);
        document.getElementById("loadingOverlay").style.display = 'none';

        $(".layer1 .list_type_incorrect_parent").click(function(e) {
            var collapse_content_selector = $(this).data('rel');
            var x = document.getElementById(collapse_content_selector);

            $('.toggle-main').addClass('unactive').removeClass('active');
            $('#' + collapse_content_selector).addClass('active').removeClass('unactive');

            $('#' + collapse_content_selector ).toggle("slide");
            $('.toggle-main.unactive').hide();

            e.preventDefault();
        });

        // handle click and save history by ChienNguyen

        $(".layer1 .toggle").click(function(e) {
            if($(this).find("div").first() && $(this).find("div").first().attr('data-rel'))
            {
                jsCookie.set('is_active_incorrect_type', $(this).find("div").first().attr('data-rel'), { expires: config.LIMIT_EXPIRES_CACHE });
            }
        });

        // set active
        if($(".layer1 .toggle #" + jsCookie.get('is_active_incorrect_type')).length)
        {
            $(".layer1 .toggle #" + jsCookie.get('is_active_incorrect_type')).attr("style","display:block");
        }

        // add list handle common
        commonFunct(config.DEFINE_PAGE_NAME.INCORRECT_LIST_TYPE);

        $(document).ready(function () {
            soundFunction();
        })
    });

    /**
     * Supplement page
     * 
     *
     * @updated 21.12.2018
     */

    page(config.subfolder + '/supplement/:categoryNo/:subCategoryNo/:quizNo?', async function(ctx) {
        // add list handle common header by ChienNguyen
        commonHeaderFunct(config.DEFINE_PAGE_NAME.SUPPLEMENT);

        // client_Js.checkInfoDeviceLogin();
        var categoryNo    = parseInt(ctx.params.categoryNo);
        var subCategoryNo = parseInt(ctx.params.subCategoryNo);
        var quizNo        = parseInt(ctx.params.quizNo);

        var quizObj = new Quiz();
        var relatedImages  = new RelatedImages();

        // get info quiz
        let infoQuiz = await quizObj.getInfoQuiz(categoryNo, subCategoryNo, quizNo);

        let url_back = jsCookie.get('last_access_history_url');
        let dataRelatedImages = null;
        let type_data_related_images = null;
        if(infoQuiz)
        {
            let infoRelatedImages = await relatedImages.getInfoRelatedImages(infoQuiz.related_image_name);
            dataRelatedImages = infoRelatedImages.data;
            if(infoQuiz.related_image_name.indexOf(".png") != -1)
            {
                type_data_related_images = 'img'
            }
            else
            {
                type_data_related_images = 'html'
            }
        }
        // 
        let templateParams = {
            'infoQuiz'                    : infoQuiz,
            'type_data_related_images'    : type_data_related_images,
            'dataRelatedImages'           : dataRelatedImages,
            'url_back'                    : url_back
        };
        
        var output = supplementTemplate({templateParams: templateParams, config: config});

         // inner html
        innerHtmlCommon(output, config.PART_CONTENT_HTML.CONTENT_BODY);

        soundFunction();

        // add list handle common
        commonFunct(config.DEFINE_PAGE_NAME.SUPPLEMENT);
    });

    page(config.subfolder + '/user/info', async function(ctx) {
        // add list handle common header by ChienNguyen
        commonHeaderFunct(config.DEFINE_PAGE_NAME.USERINFO);


        let templateParams = {
            config: config
        };

        var output = userInfoTemplate({templateParams: templateParams});

         // inner html
        innerHtmlCommon(output, config.PART_CONTENT_HTML.CONTENT_BODY);

        $('.back').click(function (e) {
            e.preventDefault();
            page.redirect(config.subfolder);
        });
        soundFunction();

        // add list handle common
        commonFunct(config.DEFINE_PAGE_NAME.USERINFO);
    });

    page('*', async function () {
        // add list handle common header by ChienNguyen
        commonHeaderFunct(config.DEFINE_PAGE_NAME.OTHER_PAGE);

        // client_Js.checkInfoDeviceLogin();
        var output = errorTemplate({config: config});

         // inner html
        innerHtmlCommon(output, config.PART_CONTENT_HTML.CONTENT_BODY);

        soundFunction();

        // add list handle common
        commonFunct(config.DEFINE_PAGE_NAME.OTHER_PAGE);
    });

    var goHome = () => {
        $('.go-back-history').click(function () {
            page.redirect(config.subfolder);
            return true;
        });
    };


    var soundFunction = (sound = false ) => {
        var soundon = localStorage.getItem("soundon");
        if(soundon === 'true'){
            $('a').click(function () {
                if ($(this).hasClass('link-quiz-item') == false) {
                    setTimeout(function (e) {
                        var myAudio = document.getElementById('audio_click');
                        myAudio.play();
                    }, 10)
                }
            })
        }
        return true;
    };

    var funSound = () => {
        var soundon = localStorage.getItem("soundon");
        if(soundon === 'true'){
            setTimeout(function (e) {
                var myAudio = document.getElementById('audio_click');
                myAudio.play();
            }, 10)
        }
    };

    var funcAnswerSeccess = (type) =>{
        $('#playaudioseccess').click(function () {
            var audioplay = document.getElementById('audio_ok');
            audioplay.play();
        });
    };
    var funcAnswerError = (type) =>{
        $('#playaudioerror').click(function () {
            var audioplay = document.getElementById('audio_ng');
            audioplay.play();
        });
    };

    page();
	
	function zoomDisable(){
      $('head meta[name=viewport]').remove();
      $('head').prepend('<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, shrink-to-fit=no" />');
    }
    function zoomEnable(){
      $('head meta[name=viewport]').remove();
      $('head').prepend('<meta name="viewport" content="width=device-width, initial-scale=1.0, shrink-to-fit=no" />');
    }

}
